% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machine.r
\name{machine}
\alias{machine}
\title{machine}
\usage{
machine(hostname, user, exec.type = .pbd_env$RPC.LI$exec.type,
  args = .pbd_env$RPC.LI$args, pport = .pbd_env$RPC.LI$pport,
  priv.key = .pbd_env$RPC.LI$priv.key,
  priv.key.ppk = .pbd_env$RPC.LI$priv.key.ppk)
}
\arguments{
\item{hostname}{the server ip or host name.}

\item{user}{user id for logging to the server.  If none is supplied, then the system user
name will be used instead.}

\item{exec.type}{either "ssh" or "plink" in character. Windows will force to use "plink".}

\item{args}{further arguments to "ssh" or "plink" for connecting to the server
in addition to port, user id, and host name.}

\item{pport}{ssh port opened on the server.}

\item{priv.key, priv.key.ppk}{location of the private key for user authentication, the file will be
checked first then \code{-i priv.key} will be added to \code{args}
when the file exists.
\code{priv.key.ppk} is only used when \code{plink} is called.}
}
\value{
An object of class \code{machine}.
}
\description{
Remote machine configuration settings.
}
\examples{
\dontrun{
# note: not my actual aws url
myaws <- machine("ec2-1-2-3-4.compute-1.amazonaws.com", user="my_aws_username")

# if you don't specify 'user', we use your host machine's user name
myvm <- machine("192.168.1.10")
}

}
