% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_get_dama_index.R
\name{f_get_dama_index}
\alias{f_get_dama_index}
\title{Get Byte Index of Files within 'DataMashup'}
\usage{
f_get_dama_index(input_file_pbix)
}
\arguments{
\item{input_file_pbix}{Path of the input '.pbix'.}
}
\value{
Bytes of 'DataMashup', including [[1]] start and end of a
parsable '.zip' file, [[2]] start of each '.zip' signature, [[3]] start and
end of xml, and [[4]] total length of 'DataMashup'.
}
\description{
The position of the start and end bytes of different files, or
their components, within 'DataMashup' are identified.
}
\examples{
\dontrun{
# Get dummy data ------------------------------------------------------------
# Create a temporary directory
temp_dir <- file.path(tempdir(),"functionTest")
if(!dir.exists(temp_dir)) {
	dir.create(temp_dir)
}
sample_file_name <- "OR_sample_func.pbix"
pathFileSample <- file.path(temp_dir, sample_file_name)

# See if dummy data already exists in temporary directory
parent_temp_dir <- dirname(temp_dir)
existing_file <- list.files(parent_temp_dir,
pattern = sample_file_name, recursive = TRUE, full.names = TRUE)

# Download the sample .pbix if it doesn't exist
if (length(existing_file) == 0) {
   url_pt1 <- "https://github.com/KoenVerbeeck/PowerBI-Course/blob/"
   url_pt2 <- "master/pbix/TopMovies.pbix?raw=true"
   url <- paste0(url_pt1, url_pt2)
   req <- download.file(url, destfile = pathFileSample, mode = "wb")
} else {
   pathFileSample <- existing_file[1]
}
# Do stuff ------------------------------------------------------------------

# Run the function
test <- f_get_dama_index(pathFileSample)
  }
}
\seealso{
Uses: \code{\link{f_get_dama}}.
}
\author{
Don Diproto
}
