% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NumArcsPEmid1D}
\alias{NumArcsPEmid1D}
\title{Number of Arcs for Proportional Edge Proximity Catch Digraphs (PE-PCDs) - middle interval case}
\usage{
NumArcsPEmid1D(dat, r, c, int)
}
\arguments{
\item{dat}{A set or vector of 1D points which constitute the vertices of PE-PCD}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region; must be \eqn{\ge 1}}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \eqn{int=(a,b)}.
For the interval, \eqn{int=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}}

\item{int}{A vector of two real numbers representing an interval}
}
\value{
Number of arcs for the PE-PCD whose vertices are the 1D data set, \code{dat},
with expansion parameter, \eqn{r \ge 1}, and centrality parameter, \code{c} in \eqn{(0,1)}. PE proximity regions are defined only
for \code{dat} points inside the interval \code{int}, i.e. arcs are possible for such points only.
}
\description{
Returns the number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs) whose vertices are the
given 1D numerical data set, \code{dat}. PE proximity region \eqn{NPE(x,r,c)} is defined with respect to the interval
\eqn{int=(a,b)} for this function.

PE proximity region is constructed with expansion parameter \eqn{r \ge 1} and
centrality parameter \code{c} in \eqn{(0,1)}.

Vertex regions are based on the center associated with the centrality parameter \code{c} in \eqn{(0,1)}.
For the interval, \eqn{int=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)} and for the number of arcs,
loops are not allowed so arcs are only possible for points inside the middle interval \code{int} for this function.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
c<-.4
r<-2
a<-0; b<-10; int<-c(a,b)

n<-10
dat<-runif(n,a,b)
NumArcsPEmid1D(dat,r,c,int)

NumArcsPEmid1D(3,r,c,int)

NumArcsPEmid1D(dat,r,c=.3,int)

NumArcsPEmid1D(dat,r=1.5,c,int)

n<-10  #try also n<-20
dat<-runif(n,a-5,b+5)
NumArcsPEmid1D(dat,r,c,int)

dat<-runif(n,a+10,b+10)
NumArcsPEmid1D(dat,r,c,int)

n<-10
dat<-runif(n,a,b)
NumArcsPEmid1D(dat,r,c,int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsPEend1D}}, \code{\link{NumArcsCSmid1D}}, and \code{\link{NumArcsCSend1D}}
}
