% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{Pg2PE1D.asy}
\alias{Pg2PE1D.asy}
\title{The asymptotic probability of domination number=2 for Proportional Edge Proximity Catch Digraphs (PE-PCDs)
- middle interval case}
\usage{
Pg2PE1D.asy(c)
}
\arguments{
\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \eqn{int=(a,b)}.
For the interval, \eqn{int=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}}
}
\value{
The asymptotic P(domination number=2) for PE-PCD whose vertices are a uniform data set in a finite
interval \eqn{(a,b)}
}
\description{
Returns the asymptotic P(domination number=2) for PE-PCD whose vertices are a uniform data set in a finite
interval \eqn{(a,b)}.

The PE proximity region \eqn{NPE(x,r,c)} is defined with respect to (a,b) with centrality parameter \code{c}
in \eqn{(0,1)} and expansion parameter \eqn{r=1/\max(c,1-c)}.
}
\examples{
c<-.5

Pg2PE1D.asy(c)

Pg2PE1D.asy(c=1/1.5)
Pg2PE1D(r=1.5,c=1/1.5,n=10)
Pg2PE1D(r=1.5,c=1/1.5,n=100)

}
\seealso{
\code{\link{Pg2PE1D}} and \code{\link{Pg2PEtri}}
}
