% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{funsCSGamTe}
\alias{funsCSGamTe}
\alias{Gam2CSTe}
\alias{Gam3CSTe}
\alias{Gam4CSTe}
\alias{Gam5CSTe}
\alias{Gam6CSTe}
\title{Four indicator functions: Gam2CSTe, Gam3CSTe, Gam4CSTe, Gam5CSTe and Gam6CSTe ---

GamkCSTe is for \eqn{k} (\eqn{k=2,3,4,5}) points constituting a dominating set for Central Similarity
Proximity Catch Digraphs (CS-PCDs) - standard equilateral triangle case}
\usage{
Gam2CSTe(pt1, pt2, Dt, t, ch.data.pnts = FALSE)

Gam3CSTe(pt1, pt2, pt3, Dt, t, ch.data.pnts = FALSE)

Gam4CSTe(pt1, pt2, pt3, pt4, Dt, t, ch.data.pnts = FALSE)

Gam5CSTe(pt1, pt2, pt3, pt4, pt5, Dt, t, ch.data.pnts = FALSE)

Gam6CSTe(pt1, pt2, pt3, pt4, pt5, pt6, Dt, t, ch.data.pnts = FALSE)
}
\arguments{
\item{pt1, pt2, pt3, pt4, pt5, pt6}{The points \{\eqn{pt1,...,ptk}\} are \eqn{k} 2D points (for \eqn{k=2,3,4,5,6}) to be
tested for constituting a dominating set of the CS-PCD}

\item{Dt}{A set of 2D points which constitutes the vertices of the CS-PCD}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region}

\item{ch.data.pnts}{A logical argument for checking whether points \{\eqn{pt1,...,ptk}\} are
data points in \code{Dt} or not (default is \code{FALSE})}
}
\value{
The function GamkCSTe returns \{\code{pt1},...,\code{ptk}\} is a dominating set of the CS-PCD) where
vertices of the CS-PCD are the 2D data set \code{Dt}), that is, returns 1 if \{\code{pt1},...,\code{ptk}\}
is a dominating set of CS-PCD, returns 0 otherwise.
}
\description{
The function GamkCSTe returns I(\{\code{pt1},...,\code{ptk}\} is a dominating set of the CS-PCD)
where vertices of CS-PCD are the 2D data set \code{Dt}, that is, returns 1 if \{\code{pt1},...,\code{ptk}\}
is a dominating set of CS-PCD, returns 0 otherwise for \eqn{k=2,3,4,5,6}.

CS proximity region is constructed with respect to \eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))}
with expansion parameter \eqn{t>0} and edge regions are based on center of mass \eqn{CM=(1/2,\sqrt{3}/6)}.

\code{ch.data.pnts} is for checking whether points \code{pt1},...,\code{ptk} are data points in \code{Dt} or not
(default is \code{FALSE}), so by default this function checks whether the points \code{pt1},...,\code{ptk} would be a
dominating set if they actually were in the data set.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
#Examples for Gam2CSTe
\donttest{
t<-1.5
n<-10

set.seed(1)
dat<-runifTe(n)$gen.points

Gam2CSTe(dat[1,],dat[2,],dat,t)
Gam2CSTe(dat[1,],dat[1,],dat,t)

Gam2CSTe(dat[1,],dat[3,],dat,t)

Gam2CSTe(c(.2,.2),dat[2,],dat,t)

Gam2CSTe(c(.2,.2),c(.2,.3),dat,t)

Gam2CSTe(c(.2,.2),c(.2,.3),rbind(c(.2,.2),c(.2,.3)),t)
Gam2CSTe(c(1.2,1.2),c(1.2,1.3),rbind(c(1.2,1.2),c(1.2,1.3)),t)

ind.gam2<-vector()
for (i in 1:(n-1))
 for (j in (i+1):n)
 {if (Gam2CSTe(dat[i,],dat[j,],dat,t)==1)
   ind.gam2<-rbind(ind.gam2,c(i,j))}

ind.gam2

P1<-c(.4,.2); P2<-c(.6,.4)
Gam2CSTe(P1,P2,dat,t)

dat.fr<-data.frame(a=dat)
Gam2CSTe(P1,P2,dat.fr,t)
}

\dontrun{
Gam2CSTe(c(.2,.2),dat[2,],dat,t,ch.data.pnts = TRUE)
#gives an error message since not both points are data points in Dt
Gam2CSTe(c(.2,.2),c(.2,.3),dat,t,ch.data.pnts = TRUE)
#gives an error message since not both points are data points in Dt
}

#Examples for Gam3CSTe
\donttest{
t<-1.5
n<-10

set.seed(1)
dat<-runifTe(n)$gen.points

Gam3CSTe(dat[1,],dat[2,],dat[3,],dat,t)

Gam3CSTe(dat[1,],dat[3,],dat[4,],dat,t)

Gam3CSTe(c(.2,.2),dat[2,],dat[3,],dat,t)

Gam3CSTe(c(.2,.2),c(.2,.3),c(.2,.4),rbind(c(.2,.2),c(.2,.3),c(.2,.4)),t)
Gam3CSTe(c(1.2,1.2),c(1.2,1.3),c(1.2,1.4),rbind(c(1.2,1.2),c(1.2,1.3),c(1.2,1.4)),t)

ind.gam3<-vector()
for (i in 1:(n-2))
 for (j in (i+1):(n-1))
   for (k in (j+1):n)
   {if (Gam3CSTe(dat[i,],dat[j,],dat[k,],dat,t)==1)
     ind.gam3<-rbind(ind.gam3,c(i,j,k))}

ind.gam3

P1<-c(.4,.2); P2<-c(.6,.4); P3<-c(.5,.1)
Gam3CSTe(P1,P2,P3,dat,t)

dat.fr<-data.frame(a=dat)
Gam3CSTe(P1,P2,P3,dat.fr,t)
}

\dontrun{
Gam3CSTe(c(.2,.2),dat[2,],dat[3,],dat,t,ch.data.pnts = TRUE)
#gives an error message since not all points, pt1, pt2, and pt3, are data points in Dt
}

#Examples for Gam4CSTe
\donttest{
t<-1.5
n<-10

set.seed(1)
dat<-runifTe(n)$gen.points

Gam4CSTe(dat[1,],dat[2,],dat[3,],dat[4,],dat,t)

Gam4CSTe(dat[1,],dat[3,],dat[4,],dat[5,],dat,t)

Gam4CSTe(c(.2,.2),dat[2,],dat[3,],dat[4,],dat,t)

Gam4CSTe(c(.2,.2),c(.2,.3),c(.2,.4),c(.2,.5),rbind(c(.2,.2),c(.2,.3),c(.2,.4),c(.2,.5)) ,t)
Gam4CSTe(c(1.2,1.2),c(1.2,1.3),c(1.2,1.4),c(1.2,1.5),
rbind(c(1.2,1.2),c(1.2,1.3),c(1.2,1.4),c(1.2,1.5)),t)

ind.gam4<-vector()
for (i in 1:(n-3))
 for (j in (i+1):(n-2))
   for (k in (j+1):(n-1))
     for (l in (k+1):n)
     {if (Gam4CSTe(dat[i,],dat[j,],dat[k,],dat[l,],dat,t)==1)
       ind.gam4<-rbind(ind.gam4,c(i,j,k,l))}

ind.gam4

P1<-c(.4,.2); P2<-c(.6,.4); P3<-c(.5,.1); P4<-c(.5,.29)
Gam4CSTe(P1,P2,P3,P4,dat,t)

dat.fr<-data.frame(a=dat)
Gam4CSTe(P1,P2,P3,P4,dat.fr,t)
}

\dontrun{
Gam4CSTe(c(.2,.2),dat[2,],dat[3,],dat[4,],dat,t,ch.data.pnts = TRUE)
#gives an error message since not all points are data points in Dt
}

#Examples for Gam5CSTe
\donttest{
t<-1.5
n<-10

set.seed(1)
dat<-runifTe(n)$gen.points

Gam5CSTe(dat[1,],dat[2,],dat[3,],dat[4,],dat[5,],dat,t)

Gam5CSTe(dat[1,],dat[3,],dat[4,],dat[5,],dat[6,],dat,t)

Gam5CSTe(c(.2,.2),dat[2,],dat[3,],dat[4,],dat[5,],dat,t)

ind.gam5<-vector()
for (i1 in 1:(n-4))
 for (i2 in (i1+1):(n-3))
   for (i3 in (i2+1):(n-2))
     for (i4 in (i3+1):(n-1))
       for (i5 in (i4+1):n)
       {if (Gam5CSTe(dat[i1,],dat[i2,],dat[i3,],dat[i4,],dat[i5,],dat,t)==1)
         ind.gam5<-rbind(ind.gam5,c(i1,i2,i3,i4,i5))}

ind.gam5

P1<-c(.4,.2); P2<-c(.6,.4); P3<-c(.5,.1); P4<-c(.5,.29); P5<-c(.3,.3)
Gam5CSTe(P1,P2,P3,P4,P5,dat,t)

dat.fr<-data.frame(a=dat)
Gam5CSTe(P1,P2,P3,P4,P5,dat.fr,t)
}

\dontrun{
Gam5CSTe(c(.2,.2),dat[2,],dat[3,],dat[4,],dat[5,],dat,t,ch.data.pnts = TRUE)
#gives an error message since not all points are data points in Dt
}

#Examples for Gam6CSTe
\donttest{
t<-1.5
n<-10

set.seed(1)
dat<-runifTe(n)$gen.points

Gam6CSTe(dat[1,],dat[2,],dat[3,],dat[4,],dat[5,],dat[6,],dat,t)

Gam6CSTe(dat[1,],dat[3,],dat[4,],dat[5,],dat[6,],dat[7,],dat,t)

Gam6CSTe(c(.2,.2),dat[2,],dat[3,],dat[4,],dat[5,],dat[6,],dat,t)

ind.gam6<-vector()
for (i1 in 1:(n-5))
 for (i2 in (i1+1):(n-4))
   for (i3 in (i2+1):(n-3))
     for (i4 in (i3+1):(n-2))
       for (i5 in (i4+1):(n-1))
         for (i6 in (i5+1):n)
         {if (Gam6CSTe(dat[i1,],dat[i2,],dat[i3,],dat[i4,],dat[i5,],dat[i6,],dat,t)==1)
           ind.gam6<-rbind(ind.gam6,c(i1,i2,i3,i4,i5,i6))}

ind.gam6

P1<-c(.4,.2); P2<-c(.6,.4); P3<-c(.5,.1); P4<-c(.5,.29); P5<-c(.3,.3); P6<-c(.4,.4)
Gam6CSTe(P1,P2,P3,P4,P5,P6,dat,t)

dat.fr<-data.frame(a=dat)
Gam6CSTe(P1,P2,P3,P4,P5,P6,dat.fr,t)
}

\dontrun{
Gam6CSTe(c(.2,.2),dat[2,],dat[3,],dat[4,],dat[5,],dat[6,],dat,t,ch.data.pnts = TRUE)
#gives an error message since not all points are data points in Dt
}

}
\seealso{
\code{\link{Gam1CSTe}}, \code{\link{Gam2PEtri}} and \code{\link{Gam2PEtetra}}
}
