% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{funsPG2PE1D}
\alias{funsPG2PE1D}
\alias{PG2AI}
\alias{PG2AII}
\alias{PG2AIII}
\alias{PG2AIV}
\alias{PG2A}
\alias{PG2Asym}
\alias{PG2BIII}
\alias{PG2B}
\alias{PG2Bsym}
\alias{PG2CIV}
\alias{PG2C}
\alias{PG2Csym}
\alias{Pg2PE1D}
\title{The function \code{Pg2PE1D} and its auxiliary functions ---

The functions for probability of domination number=2 for Proportional Edge Proximity Catch Digraphs
(PE-PCDs) - middle interval case}
\usage{
PG2AI(r, c, n)

PG2AII(r, c, n)

PG2AIII(r, c, n)

PG2AIV(r, c, n)

PG2A(r, c, n)

PG2Asym(r, c, n)

PG2BIII(r, c, n)

PG2B(r, c, n)

PG2Bsym(r, c, n)

PG2CIV(r, c, n)

PG2C(r, c, n)

PG2Csym(r, c, n)

Pg2PE1D(r, c, n)
}
\arguments{
\item{r}{A positive real number which serves as the expansion parameter in PE proximity region; must be \eqn{\ge 1}}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \eqn{int=(a,b)}.
For the interval, \eqn{int=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}}

\item{n}{A positive integer representing the size of the uniform data set}
}
\value{
P(domination number=2) for PE-PCD whose vertices are a uniform data set of size \code{n} in a finite
interval \eqn{(a,b)}
}
\description{
Returns \eqn{P(\gamma=2)} for PE-PCD whose vertices are a uniform data set of size \code{n} in a finite interval
(a,b)where \eqn{\gamma} stans for the domination number.

The PE proximity region \eqn{NPE(x,r,c)} is defined with respect to (a,b) with centrality parameter \code{c} in \eqn{(0,1)}
and expansion parameter \eqn{r \ge 1}.

To compute the probability \eqn{P(\gamma=2)} for PE-PCD in the 1D case,
we partition the domain \eqn{(r,c)=(1,\infty) \times (0,1)}, and compute the probability for each partition
set. The sample size (i.e. number of vertices or data points) is a positive integer, \code{n}.

The auxiliary functions are \code{PG2AI, PG2AII, PG2AIII, PG2AIV, PG2A, PG2Asym, PG2BIII, PG2B, PG2B,
PG2Bsym, PG2CIV, PG2C}, and \code{PG2Csym}, each corresponding to a partition of the domain of \code{r} and \code{c}.
In particular, in
CASE A: \code{c} in \eqn{((3-\sqrt{5})/2, 1/2)}, we compute \eqn{P(\gamma=2)} with

PG2AIV(r,c,n) if \eqn{1 < r < (1-c)/c};

PG2AIII(r,c,n) if \eqn{(1-c)/c< r < 1/(1-c)};

PG2AII(r,c,n) if \eqn{1/(1-c)< r < 1/c};

and PG2AI(r,c,n) otherwise.

PG2A(r,c,n) combines these functions in CASE A: \code{c} in \eqn{((3-\sqrt{5})/2,1/2)}.
Due to the symmetry in the PE proximity regions, we use PG2Asym(r,c,n) for \code{c} in
\eqn{(1/2,(\sqrt{5}-1)/2)} with the same auxiliary functions

PG2AIV(r,1-c,n) if \eqn{1 < r < c/(1-c)};

PG2AIII(r,1-c,n) if \eqn{(c/(1-c) < r < 1/c};

PG2AII(r,1-c,n) if \eqn{1/c < r < 1/(1-c)};

and PG2AI(r,1-c,n) otherwise.

In CASE B: \code{c} in \eqn{(1/4,(3-\sqrt{5})/2)}, we compute \eqn{P(\gamma=2)} with

PG2AIV(r,c,n) if \eqn{1 < r < 1/(1-c)};

PG2BIII(r,c,n) if \eqn{1/(1-c) < r < (1-c)/c};

PG2AII(r,c,n) if \eqn{(1-c)/c < r < 1/c};

and PG2AI(r,c,n) otherwise.

PG2B(r,c,n) combines these functions in CASE B: \code{c} in \eqn{(1/4,(3-\sqrt{5})/2)}.
Due to the symmetry in the PE proximity regions, we use PG2Bsym(r,c,n) for \code{c} in
\eqn{((\sqrt{5}-1)/2,3/4)} with the same auxiliary functions

PG2AIV(r,1-c,n) if \eqn{ 1< r < 1/c};

PG2BIII(r,1-c,n) if \eqn{1/c < r < c/(1-c)};

PG2AII(r,1-c,n) if \eqn{c/(1-c) < r < 1/(1-c)};

and PG2AI(r,1-c,n) otherwise.

In CASE C: \code{c} in \eqn{(0,1/4)}, we compute \eqn{P(\gamma=2)} with

PG2AIV(r,c,n) if \eqn{1< r < 1/(1-c)};

PG2BIII(r,c,n) if \eqn{1/(1-c) < r < (1-\sqrt{1-4 c})/(2 c)};

PG2CIV(r,c,n) if \eqn{(1-\sqrt{1-4 c})/(2 c) < r < (1+\sqrt{1-4 c})/(2 c)};

PG2BIII(r,c,n) if \eqn{(1+\sqrt{1-4 c})/(2 c) < r <1/(1-c)};

PG2AII(r,c,n) if \eqn{1/(1-c) < r < 1/c};

and PG2AI(r,c,n) otherwise.

PG2C(r,c,n) combines these functions in CASE C: \code{c} in \eqn{(0,1/4)}.
Due to the symmetry in the PE proximity regions, we use PG2Csym(r,c,n) for \code{c} in \eqn{(3/4,1)}
with the same auxiliary functions

PG2AIV(r,1-c,n) if \eqn{1< r < 1/c};

PG2BIII(r,1-c,n) if \eqn{1/c < r < (1-\sqrt{1-4(1-c)})/(2(1-c))};

PG2CIV(r,1-c,n) if \eqn{(1-\sqrt{1-4(1-c)})/(2(1-c)) < r < (1+\sqrt{1-4(1-c)})/(2(1-c))};

PG2BIII(r,1-c,n) if \eqn{(1+\sqrt{1-4(1-c)})/(2(1-c)) < r < c/(1-c)};

PG2AII(r,1-c,n) if \eqn{c/(1-c)< r < 1/(1-c)};

and PG2AI(r,1-c,n) otherwise.

Combining CASES A, B, AND C, we get our main function \code{Pg2PE1D} which computes \eqn{P(\gamma=2)}
for any (\code{r,c}) in its domain.
}
\examples{
#Examples for the auxiliary functions
\donttest{
PG2AI(2.25,.45,10)
}

\donttest{
PG2AII(2.2,.4,10)
}

\donttest{
PG2AIII(1.2,.25,10)
}

\donttest{
PG2AIV(1.2,.25,10)
}

\donttest{
PG2A(1.2,.25,10)
}

\donttest{
PG2Asym(1.2,.75,10)
}

\donttest{
PG2BIII(1.5,.45,10)
}

\donttest{
PG2B(1.5,.30,10)
}

\donttest{
PG2Bsym(1.5,.70,10)
}

\donttest{
PG2CIV(1.5,.2,10)
}

\donttest{
PG2C(1.5,.2,10)
}

\donttest{
PG2Csym(1.5,.8,10)
}

#Examples for the main function Pg2PE1D
r<-2
c<-.5
n<-10

Pg2PE1D(r,c,n)

Pg2PE1D(r=1.5,c=1/1.5,n=100)

}
\seealso{
\code{\link{Pg2PEtri}} and  \code{\link{Pg2PE1D.asy}}
}
