% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxRFuncs4PCDClasses.r
\name{summary.Patterns}
\alias{summary.Patterns}
\title{Return a summary of a \code{Patterns} object}
\usage{
\method{summary}{Patterns}(object, ...)
}
\arguments{
\item{object}{Object of class \code{Patterns}}

\item{\dots}{Additional parameters for \code{summary}.}
}
\value{
The \code{call} of the object of class '\code{Patterns}', the \code{type} of the pattern, \code{parameters} of the pattern,
study window, some sample points from the generated pattern, reference points (if any for the bivariate pattern),
and number of points for each class
}
\description{
Returns the below information about the \code{object}:

\code{call} of the function defining the \code{object}, the \code{type} of the pattern, \code{parameters} of the pattern,
study window, some sample points from the generated pattern, reference points (if any for the bivariate pattern),
and number of points for each class
}
\examples{
nx<-20; #try also 100 and 1000
ny<-3; #try also 1
e<-.15;
Y<-cbind(runif(ny),runif(ny)) #with default bounding box (i.e., unit square)

Xdt<-rseg.disc(nx,Y,e)
Xdt
summary(Xdt)

}
\seealso{
\code{\link{print.Patterns}}, \code{\link{print.summary.Patterns}}, and \code{\link{plot.Patterns}}
}
