% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{IndNPEtriSet}
\alias{IndNPEtriSet}
\title{The indicator for the presence of an arc from a point in set \code{S} to the point \code{pt} for
Proportional Edge Proximity Catch Digraphs (PE-PCDs) - one triangle case}
\usage{
IndNPEtriSet(S, pt, r, tri, M = c(1, 1, 1))
}
\arguments{
\item{S}{A set of 2D points. Presence of an arc from a point in \code{S} to point \code{pt} is checked
by the function.}

\item{pt}{A 2D point. Presence of an arc from a point in \code{S} to point \code{pt} is checked
by the function.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region
constructed in the triangle \code{tri}; must be \eqn{\ge 1}.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri} or the circumcenter of \code{tri};
default is \eqn{M=(1,1,1)} i.e. the center of mass of \code{tri}.}
}
\value{
I(\code{pt} is in U_{x in \code{S}} NPE(x,r)), that is, returns 1 if \code{pt} is in \code{S} or inside \eqn{NPE(x,r)} for at least
one x in \code{S}, returns 0 otherwise where PE proximity region is constructed with respect to the triangle \code{tri}
}
\description{
Returns I(\code{pt} in \eqn{NPE(x,r)} for some x in \code{S}), that is, returns 1 if \code{pt} is in \eqn{\cup_{x in S}NPE(x,r)},
returns 0 otherwise.

PE proximity region is constructed with respect to the triangle \code{tri} with
the expansion parameter \eqn{r \ge 1} and vertex regions are based on the center, \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of the triangle \code{tri}
or based on the circumcenter of \code{tri}; default is \eqn{M=(1,1,1)} i.e. the center of mass of \code{tri}.
Vertices of \code{tri} are also labeled as 1, 2, and 3, respectively.

If \code{pt} is not in \code{S} and either \code{pt} or all points in \code{S} are outside \code{tri}, it returns 0,
but if \code{pt} is in \code{S}, then it always returns 1 regardless of its location (i.e., loops are allowed).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
dat<-runif.tri(n,Tr)$gen.points

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

r<-1.5

S<-rbind(dat[1,],dat[2,])  #try also S<-c(1.5,1)

IndNPEtriSet(S,dat[3,],r,Tr,M)
IndNPEtriSet(S,dat[3,],r=1,Tr,M)
IndNPEtriSet(S,dat[3,],r=1.5,Tr,M)

S<-rbind(dat[1,],dat[2,],dat[3,],dat[5,])
IndNPEtriSet(S,dat[3,],r,Tr,M)

IndNPEtriSet(S,dat[6,],r,Tr,M)
IndNPEtriSet(S,dat[6,],r=1.25,Tr,M)

S<-rbind(c(.1,.1),c(.3,.4),c(.5,.3))
IndNPEtriSet(S,dat[3,],r,Tr,M)

IndNPEtriSet(c(.2,.5),dat[2,],r,Tr,M)
IndNPEtriSet(dat,c(.2,.5),r,Tr,M)
IndNPEtriSet(dat,dat[2,],r,Tr,M)
IndNPEtriSet(c(.2,.5),c(.2,.5),r,Tr,M)
IndNPEtriSet(dat[5,],dat[2,],r,Tr,M)

S<-rbind(dat[1,],dat[2,],dat[3,],dat[5,],c(.2,.5))
IndNPEtriSet(S,dat[3,],r,Tr,M)

P<-c(.4,.2)
S<-dat[c(1,3,4),]
IndNPEtriSet(dat,P,r,Tr,M)

IndNPEtriSet(rbind(S,S),P,r,Tr,M)

dat.fr<-data.frame(a=S)
IndNPEtriSet(dat.fr,P,r,Tr,M)

}
\seealso{
\code{\link{IndNPETeSet}}, \code{\link{IndNPEtri}}, \code{\link{IndNPETe}},
\code{\link{IndNAStriSet}}, and \code{\link{IndNCStriSet}}
}
