% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NumArcsCSmid1D}
\alias{NumArcsCSmid1D}
\title{Number of Arcs of of Central Similarity Proximity Catch Digraphs (CS-PCDs) - middle interval case}
\usage{
NumArcsCSmid1D(dat, t, c, int)
}
\arguments{
\item{dat}{A set or vector of 1D points which constitute the vertices of CS-PCD.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \eqn{int=(a,b)}.
For the interval, \eqn{int=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}

\item{int}{A vector of two real numbers representing an interval.}
}
\value{
Number of arcs for the PE-PCD whose vertices are the 1D data set, \code{dat},
with expansion parameter, \eqn{r \ge 1}, and centrality parameter, \code{c} in \eqn{(0,1)}. PE proximity regions are defined only
for \code{dat} points inside the interval \code{int}, i.e. arcs are possible for such points only.
}
\description{
Returns the number of arcs of of Central Similarity Proximity Catch Digraphs (CS-PCDs) whose vertices are
the given 1D numerical data set, \code{dat}.

CS proximity region \eqn{NCS(x,t,c)} is defined with respect to the interval
\eqn{int=(a,b)} for this function. CS proximity region is constructed with expansion parameter \eqn{t>0} and
centrality parameter \code{c} in \eqn{(0,1)}.

Vertex regions are based on the center associated with the centrality parameter \code{c} in \eqn{(0,1)}.
For the interval, \eqn{int=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)} and for the number of arcs,
loops are not allowed so arcs are only possible for points inside the middle interval \code{int} for this function.

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
c<-.4
t<-2
a<-0; b<-10; int<-c(a,b)

n<-10
dat<-runif(n,a,b)
NumArcsCSmid1D(dat,t,c,int)

NumArcsCSmid1D(dat,t,c=.3,int)

NumArcsCSmid1D(dat,t=1.5,c,int)

NumArcsCSmid1D(dat,t,c,int+5)
NumArcsCSmid1D(dat,t,c,int+10)

n<-10  #try also n<-20
dat<-runif(n,a-5,b+5)
NumArcsCSint(dat,t,c,int)

dat<-runif(n,a+10,b+10)
NumArcsCSmid1D(dat,t,c,int)

n<-10
dat<-runif(n,a,b)
NumArcsCSmid1D(dat,t,c,int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsCSend1D}}, \code{\link{NumArcsPEmid1D}}, and \code{\link{NumArcsPEend1D}}
}
