% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{isStdEqTri}
\alias{isStdEqTri}
\title{Check whether a triangle is a standard equilateral triangle}
\usage{
isStdEqTri(tri)
}
\arguments{
\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}
}
\value{
\code{TRUE} if \code{tri} is a standard equilateral triangle, else \code{FALSE}.
}
\description{
Checks whether the triangle, \code{tri}, is the standard equilateral triangle \eqn{T_e=T((0,0),(1,0),(1/2,\sqrt{3}/2))}
or not.
}
\examples{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C)  #try adding +10^(-16) to each vertex
isStdEqTri(Te)

isStdEqTri(Te)

Te<-rbind(B,C,A)
isStdEqTri(Te)

Tr<-rbind(A,B,-C)
isStdEqTri(Tr)

A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
isStdEqTri(Tr)

A<-c(0,0); B<-c(1,0); C<-c(.5,0.8660254);
Te<-rbind(A,B,C)
isStdEqTri(Te)

isStdEqTri(rbind(A,A,B))

dat.fr<-data.frame(a=Te)
isStdEqTri(dat.fr)

}
