% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxRFuncs4PCDClasses.r
\name{plot.Patterns}
\alias{plot.Patterns}
\title{Plot a \code{Patterns} object}
\usage{
\method{plot}{Patterns}(x, asp = NA, xlab = "x", ylab = "y", ...)
}
\arguments{
\item{x}{Object of class \code{Patterns}.}

\item{asp}{A numeric value, giving the aspect ratio for y axis to x-axis y/x (default is \code{NA}),
see the official help for \code{asp} by typing "? asp".}

\item{xlab, ylab}{Titles for the x and y axes, respectively (default is \code{xlab}="x" and \code{ylab}="y").}

\item{\dots}{Additional parameters for \code{plot}.}
}
\value{
None
}
\description{
Plots the points generated from the pattern (color coded for each class) together with the
study window
}
\examples{
nx<-20; #try also 100 and 1000
ny<-3; #try also 1
e<-.15;
Y<-cbind(runif(ny),runif(ny)) #with default bounding box (i.e., unit square)

Xdt<-rseg.disc(nx,Y,e)
Xdt
plot(Xdt,asp=1)

}
\seealso{
\code{\link{print.Patterns}}, \code{\link{summary.Patterns}}, and \code{\link{print.summary.Patterns}}
}
