% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{plotASarcsTri}
\alias{plotASarcsTri}
\title{The plot of the arcs of Arc Slice Proximity Catch Digraph (AS-PCD) for a 2D data set - one triangle case}
\usage{
plotASarcsTri(
  Xp,
  tri,
  M = "CC",
  asp = NA,
  main = "",
  xlab = "",
  ylab = "",
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the AS-PCD.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{The center of the triangle. "CC" stands for circumcenter of the triangle \code{tri} or a 2D point in Cartesian coordinates or a 3D point in
barycentric coordinates which serves as a center in the interior of the triangle \eqn{T_b};
default is \code{M}="CC" i.e. the circumcenter of \code{tri}.}

\item{asp}{A numeric value, giving the aspect ratio for y axis to x-axis y/x (default is \code{NA}),
see the official help for \code{asp} by typing "? asp".}

\item{main}{An overall title for the plot (default="").}

\item{xlab, ylab}{Titles for the x and y axes, respectively (default="" for both).}

\item{xlim, ylim}{Numeric vectors of length 2, giving the x- and y-coordinate ranges
(default=\code{NULL} for both).}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
A plot of the arcs of the AS-PCD for a 2D data set \code{Xp} where AS proximity regions
are defined with respect to the triangle \code{tri}; also plots the triangle \code{tri}
}
\description{
Plots the arcs of AS-PCD whose vertices are the data points, \code{Xp} and the triangle \code{tri}. AS proximity regions
are constructed with respect to the triangle \code{tri}, i.e. only for \code{Xp} points inside the triangle \code{tri}.

Vertex regions are based on the center \code{M}="CC" for
circumcenter of \code{tri}; or \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric
coordinates in the interior of the triangle \code{tri}; default is \code{M}="CC" the circumcenter of \code{tri}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
dat<-runif.tri(n,Tr)$g  #try also dat<-cbind(runif(n,1,2),runif(n,0,2))

M<-as.numeric(runif.tri(1,Tr)$g)  #try also  #M<-c(1.6,1.2)

if (dimension(M)==3) {M<-bary2cart(M,Tr)}
#need to run this when M is given in barycentric coordinates

CC<-circ.cent.tri(Tr)
if (isTRUE(all.equal(M,CC)) || identical(M,"CC"))
{cent<-CC
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)
cent.name<-"CC"
} else
{cent<-M
cent.name<-"M"
Ds<-cp2e.tri(Tr,M)
D1<-Ds[1,]; D2<-Ds[2,]; D3<-Ds[3,]
}

Xlim<-range(Tr[,1],dat[,1])
Ylim<-range(Tr[,2],dat[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plotASarcsTri(dat,Tr,M,main="arcs of AS-PCD",xlab="",ylab="",
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
L<-rbind(cent,cent,cent); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

txt<-rbind(Tr,cent,Ds)
xc<-txt[,1]+c(-.02,.03,.03,.03,.05,-0.03,-.01)
yc<-txt[,2]+c(.02,.02,.02,.07,.02,.05,-.06)
txt.str<-c("A","B","C",cent.name,"D1","D2","D3")
text(xc,yc,txt.str)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotASarcsMT}}, \code{\link{plotPEarcsTri}}, \code{\link{plotPEarcsMT}},
\code{\link{plotCSarcsTri}}, and \code{\link{plotCSarcsMT}}
}
