% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{rv.mid.int}
\alias{rv.mid.int}
\title{The index of the vertex region in a middle interval that contains a given point}
\usage{
rv.mid.int(pt, c, int)
}
\arguments{
\item{pt}{A 1D point. The vertex region \code{pt} resides is to be found.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \eqn{int=(a,b)}.
For the interval, \eqn{int=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}

\item{int}{A vector of two real numbers representing an interval.}
}
\value{
A list with two elements
\item{rv}{Index of the vertex in the interval \code{int} whose region contains point, \code{pt}.}
\item{int}{The vertices of the interval as a vector where position of the vertex corresponds to
the vertex index as \eqn{int=(rv=1,rv=2)}.}
}
\description{
Returns the index of the vertex whose region contains point \code{pt} in
the interval \eqn{int=(a,b)=(vertex 1,vertex 2)} with (parameterized) center \eqn{M_c} associated with
the centrality parameter \code{c} in \eqn{(0,1)}; vertices of interval are labeled as 1 and 2 according to their
order in the interval \code{int}. If the point, \code{pt}, is not inside \code{int}, then the function yields \code{NA} as output.
The corresponding vertex region is the interval \eqn{(a,b)} as \eqn{(a,M_c)} and \eqn{(M_c,b)} where \eqn{M_c=a+c(b-a)}.

See also (\insertCite{ceyhan:metrika-2012,ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
c<-.4
a<-0; b<-10; int<-c(a,b)

Mc<-centMc(int,c)

rv.mid.int(6,c,int)

rv.mid.int(3,c,int)

rv.mid.int(13,c,int)

rv.mid.int(4,c,int)
rv.mid.int(0,c,int)
rv.mid.int(-3,c,int)

n<-10  #try also n<-20
xr<-range(a,b,Mc)
xf<-(xr[2]-xr[1])*.5
dat<-runif(n,a,b)

Rv<-vector()
for (i in 1:n)
  Rv<-c(Rv,rv.mid.int(dat[i],c,int)$rv)
Rv

jit<-.1
yjit<-runif(n,-jit,jit)

Xlim<-range(a,b,dat)
xd<-Xlim[2]-Xlim[1]

plot(cbind(Mc,0),main="vertex region indices for the points", xlab=" ", ylab=" ",
     xlim=Xlim+xd*c(-.05,.05),ylim=3*range(yjit),pch=".",cex=3)
abline(h=0)
points(dat,yjit)
abline(v=c(a,b,Mc),lty=2,col=c(1,1,2))
text(dat,yjit,labels=factor(Rv))
text(cbind(c(a,b,Mc),.02),c("rv=1","rv=2","Mc"))

rv.mid.int(6,c,int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rv.end.int}}
}
