% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{IndNCSend1D}
\alias{IndNCSend1D}
\title{The indicator for the presence of an arc from a point to another for
Central Similarity Proximity Catch Digraphs (CS-PCDs) - end interval case}
\usage{
IndNCSend1D(x1, x2, t, int, rv = NULL)
}
\arguments{
\item{x1}{A 1D point for which the CS proximity region is constructed.}

\item{x2}{A 1D point to check whether it is inside the proximity region or not.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{rv}{Index of the end interval containing the point, either \code{1,2} or \code{NULL} (default=\code{NULL}).}
}
\value{
\eqn{I(x_2} in \eqn{N_{CS}(x_1,t))} for points \eqn{x_1} and \eqn{x_2}, that is, returns 1 if \eqn{x_2} is in \eqn{N_{CS}(x_1,t)}
(i.e., if there is an arc from \eqn{x_1} to \eqn{x_2}), returns 0 otherwise
}
\description{
Returns \eqn{I(x_2} in \eqn{N_{CS}(x_1,t))} for points \eqn{x_1} and \eqn{x_2}, that is, returns 1 if \eqn{x_2} is in \eqn{N_{CS}(x_1,t)}, returns 0
otherwise, where \eqn{N_{CS}(x,t)} is the CS proximity region for point \eqn{x} with expansion parameter \eqn{t>0}
for the region outside the interval \eqn{(a,b)}.

\code{rv} is the index of the end vertex region \eqn{x_1} resides, with default=\code{NULL},
and \code{rv=1} for left end interval and \code{rv=2} for the right end interval.
If \eqn{x_1} and \eqn{x_2} are distinct and either of them are inside interval \code{int}, it returns 0,
but if they are identical, then it returns 1 regardless of their locations (i.e., it allows loops).

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
a<-0; b<-10; int<-c(a,b)
t<-2

IndNCSend1D(15,17,t,int)
IndNCSend1D(15,15,t,int)

IndNCSend1D(1.5,17,t,int)
IndNCSend1D(1.5,1.5,t,int)

IndNCSend1D(-15,17,t,int)

IndNCSend1D(-15,-17,t,int)

a<-0; b<-10; int<-c(a,b)
t<-.5

IndNCSend1D(15,17,t,int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IndNCSmid1D}}, \code{\link{IndNPEmid1D}}, and \code{\link{IndNPEend1D}}
}
\author{
Elvan Ceyhan
}
