% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{TSArcDensCSMT}
\alias{TSArcDensCSMT}
\title{A test of segregation/association based on arc density of Central Similarity Proximity Catch Digraph
(CS-PCD) for 2D data}
\usage{
TSArcDensCSMT(
  Xp,
  Yp,
  t,
  ch.cor = FALSE,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the CS-PCD.}

\item{Yp}{A set of 2D points which constitute the vertices of the Delaunay triangles.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{ch.cor}{A logical argument for convex hull correction, default \code{ch.cor=FALSE},
recommended when both \code{Xp} and \code{Yp} have the same rectangular support.}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}.}

\item{conf.level}{Level of the confidence interval, default is \code{0.95}, for the arc density of CS-PCD based on
the 2D data set \code{Xp}.}
}
\value{
A \code{list} with the elements
\item{statistic}{Test statistic}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding \code{alternative}}
\item{conf.int}{Confidence interval for the arc density at the given confidence level \code{conf.level} and
depends on the type of \code{alternative}.}
\item{estimate}{Estimate of the parameter, i.e., arc density}
\item{null.value}{Hypothesized value for the parameter, i.e., the null arc density, which is usually the
mean arc density under uniform distribution.}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set}
}
\description{
An object of class \code{"htest"} (i.e., hypothesis test) function which performs a hypothesis test of complete spatial
randomness (CSR) or uniformity of \code{Xp} points in the convex hull of \code{Yp} points against the alternatives
of segregation (where \code{Xp} points cluster away from \code{Yp} points) and association (where \code{Xp} points cluster around
\code{Yp} points) based on the normal approximation of the arc density of the CS-PCD for uniform 2D data
in the convex hull of \code{Yp} points.

The function yields the test statistic, \eqn{p}-value for the corresponding \code{alternative},
the confidence interval, estimate and null value for the parameter of interest (which is the arc density),
and method and name of the data set used.

Under the null hypothesis of uniformity of \code{Xp} points in the convex hull of \code{Yp} points, arc density
of CS-PCD whose vertices are \code{Xp} points equals to its expected value under the uniform distribution and
\code{alternative} could be two-sided, or left-sided (i.e., data is accumulated around the \code{Yp} points, or association)
or right-sided (i.e., data is accumulated around the centers of the triangles, or segregation).

CS proximity region is constructed with the expansion parameter \eqn{t>0} and \eqn{CM}-edge regions
(i.e., the test is not available for a general center \eqn{M} at this version of the function).

This test is more appropriate when supports of \code{Xp} and \code{Yp} has a substantial overlap.

\code{ch.cor} is for convex hull correction (default is \code{"no convex hull correction"}, i.e., \code{ch.cor=FALSE})
which is recommended when both \code{Xp} and \code{Yp} have the same rectangular support.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}).
}
\examples{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-30; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx),runif(nx))
Yp<-cbind(runif(ny),runif(ny))

oldpar <- par(no.readonly = TRUE)
plotDeltri(Xp,Yp,xlab="",ylab = "")
par(oldpar)

NumArcsCSMT(Xp,Yp,t=.5)

TSArcDensCSMT(Xp,Yp,t=.5)
TSArcDensCSMT(Xp,Yp,t=.5,ch=TRUE)

NumArcsCSMT(Xp,Yp,t=1.0)
TSArcDensCSMT(Xp,Yp,t=1.0)
TSArcDensCSMT(Xp,Yp,t=1.0,ch=TRUE)

NumArcsCSMT(Xp,Yp,t=1.5)
TSArcDensCSMT(Xp,Yp,t=1.5)
TSArcDensCSMT(Xp,Yp,t=1.5,ch=TRUE)

t<-2
TSArcDensCSMT(Xp,Yp,t)

Xp<-runif.tri(nx,Yp[1:3,])$g
TSArcDensCSMT(Xp,Yp[1:3,],t)

TSArcDensCSMT(Xp,rbind(Yp,Yp),t)

dat.fr<-data.frame(a=Xp)
TSArcDensCSMT(dat.fr,Yp,t)

dat.fr<-data.frame(a=Yp)
TSArcDensCSMT(Xp,dat.fr,t)

TSArcDensCSMT(Xp,Yp,t=.5)
#gives an error message if Xp=c(.4,.2) since not enough points in the convex hull
#of non-target points to compute arc density of the target points

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{TSArcDensPEMT}} and \code{\link{TSArcDensCS1D}}
}
\author{
Elvan Ceyhan
}
