% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxRFuncs4PCDClasses.r
\name{plot.Planes}
\alias{plot.Planes}
\title{Plot a \code{Planes} \code{object}}
\usage{
\method{plot}{Planes}(x, xlab = "x", ylab = "y", zlab = "z", ...)
}
\arguments{
\item{x}{Object of class \code{Planes}.}

\item{xlab, ylab, zlab}{Titles for the \eqn{x}, \eqn{y}, and \eqn{z} axes, respectively (default is \code{xlab="x"}, \code{ylab="y"},
and \code{zlab="z"}).}

\item{\dots}{Additional parameters for \code{plot}.}
}
\value{
None
}
\description{
Plots the plane together with the defining 3D \code{points}.
}
\examples{
A<-c(1,10,3); B<-c(1,1,3); C<-c(3,9,12)
pts<-rbind(A,B,C)

xr<-range(pts[,1]); yr<-range(pts[,2])
xf<-(xr[2]-xr[1])*.1 #how far to go at the lower and upper ends in the x-coordinate
yf<-(yr[2]-yr[1])*.1 #how far to go at the lower and upper ends in the y-coordinate
x<-seq(xr[1]-xf,xr[2]+xf,l=100)
y<-seq(yr[1]-yf,yr[2]+yf,l=100)

plABC<-Plane(A,B,C,x,y)
plABC
plot(plABC)

}
\seealso{
\code{\link{print.Planes}}, \code{\link{summary.Planes}}, and \code{\link{print.summary.Planes}}
}
