% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{re.tri.cent}
\alias{re.tri.cent}
\title{The index of the edge region in a triangle that contains the point}
\usage{
re.tri.cent(pt, tri, M)
}
\arguments{
\item{pt}{A 2D point for which \code{M}-edge region it resides in is to be determined in the triangle
\code{tri}.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri}.}
}
\value{
A \code{list} with three elements
\item{re}{Index of the \code{M}-edge region that contains point, \code{pt} in the triangle \code{tri}.}
\item{tri}{The vertices of the triangle, where row labels are \eqn{A}, \eqn{B}, and \eqn{C}
with edges are labeled as 3 for edge \eqn{AB}, 1 for edge \eqn{BC}, and 2 for edge \eqn{AC}.}
\item{desc}{Description of the edge labels}
}
\description{
Returns the index of the edge whose region contains point, \code{pt}, in
the triangle \code{tri}\eqn{=T(A,B,C)} with edge regions based on center \eqn{M=(m_1,m_2)} in Cartesian coordinates or
\eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of the triangle \code{tri}.

Edges are labeled as 3 for edge \eqn{AB}, 1 for edge \eqn{BC}, and 2 for edge \eqn{AC}.
If the point, \code{pt}, is not inside \code{tri}, then the function yields \code{NA} as output.
Edge region 1 is the triangle \eqn{T(B,C,M)}, edge region 2 is \eqn{T(A,C,M)}, and edge region 3 is \eqn{T(A,B,M)}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012,ceyhan:arc-density-CS;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);

P<-c(1.4,1.2)
M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.2)

re.tri.cent(P,Tr,M)

P<-c(.8,.2)
re.tri.cent(P,Tr,M)

P<-c(1.5,1.61)
re.tri.cent(P,Tr,M)

re.tri.cent(A,Tr,M)
re.tri.cent(B,Tr,M)
re.tri.cent(C,Tr,M)
re.tri.cent(M,Tr,M)

n<-10  #try also n<-20
dat<-runif.tri(n,Tr)$g

re<-vector()
for (i in 1:n)
  re<-c(re,re.tri.cent(dat[i,],Tr,M)$re)
re

Xlim<-range(Tr[,1],dat[,1])
Ylim<-range(Tr[,2],dat[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

if (dimension(M)==3) {M<-bary2cart(M,Tr)}

plot(Tr,xlab="",ylab="",axes=TRUE,pch=".",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(dat,pch=".")
L<-Tr; R<-rbind(M,M,M)
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
text(dat,labels=factor(re))

txt<-rbind(Tr,M)
xc<-txt[,1]
yc<-txt[,2]
txt.str<-c("A","B","C","M")
text(xc,yc,txt.str)

p1<-(A+B+M)/3
p2<-(B+C+M)/3
p3<-(A+C+M)/3

plot(Tr,xlab="",ylab="",axes=TRUE,pch=".",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
L<-Tr; R<-rbind(M,M,M)
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

txt<-rbind(Tr,M,p1,p2,p3)
xc<-txt[,1]+c(-.02,.02,.02,.02)
yc<-txt[,2]+c(.02,.02,.04,.05)
txt.str<-c("A","B","C","M","re=3","re=1","re=2")
text(xc,yc,txt.str)

dat.fr<-data.frame(a=Tr)
re.tri.cent(P,dat.fr,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{re.triCM}}, \code{\link{re.bastriCM}},
\code{\link{re.bastri.cent}}, \code{\link{reTeCM}}, and \code{\link{redge.triCM}}
}
\author{
Elvan Ceyhan
}
