% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge3D.R
\name{plotPEregs.std.tetra}
\alias{plotPEregs.std.tetra}
\title{The plot of the Proportional Edge (PE) Proximity Regions for a 3D data set - standard
regular tetrahedron case}
\usage{
plotPEregs.std.tetra(
  Xp,
  r,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  zlab = NULL,
  xlim = NULL,
  ylim = NULL,
  zlim = NULL,
  ...
)
}
\arguments{
\item{Xp}{A set of 3D points for which PE proximity regions are constructed.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{main}{An overall title for the plot (default=\code{NULL}).}

\item{xlab, ylab, zlab}{titles for the \eqn{x}, \eqn{y}, and \eqn{z} axes, respectively (default=\code{NULL} for all).}

\item{xlim, ylim, zlim}{Two \code{numeric} vectors of length 2, giving the \eqn{x}-, \eqn{y}-, and \eqn{z}-coordinate ranges
(default=\code{NULL} for all).}

\item{\dots}{Additional \code{scatter3D} parameters.}
}
\value{
Plot of the PE proximity regions for points inside the standard regular tetrahedron \eqn{T_h}
(and just the points outside \eqn{T_h})
}
\description{
Plots the points in and outside of the standard regular tetrahedron
\eqn{T_h=T((0,0,0),(1,0,0),(1/2,\sqrt{3}/2,0),(1/2,\sqrt{3}/6,\sqrt{6}/3))} and also the PE proximity regions
for points in data set \code{Xp}.

PE proximity regions are defined with respect to the standard regular tetrahedron \eqn{T_h}
with expansion parameter \eqn{r \ge 1}, so PE proximity regions are defined only for points inside \eqn{T_h}.

Vertex regions are based on circumcenter (which is equivalent to the center of mass for the standard
regular tetrahedron) of \eqn{T_h}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0); D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
tetra<-rbind(A,B,C,D)
r<-1.5

n<-3  #try also n<-20
Xp<-runif.std.tetra(n)$g  #try also Xp[,1]<-Xp[,1]+1

plotPEregs.std.tetra(Xp[1:3,],r)

P1<-c(.1,.1,.1)
plotPEregs.std.tetra(rbind(P1,P1),r)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotPEregs}}, \code{\link{plotASregs.tri}}, \code{\link{plotASregs}},
\code{\link{plotCSregs.tri}}, and \code{\link{plotCSregs}}
}
\author{
Elvan Ceyhan
}
