% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassFunctions.R
\name{print.Lines}
\alias{print.Lines}
\title{Print a \code{Lines} \code{object}}
\usage{
\method{print}{Lines}(x, ...)
}
\arguments{
\item{x}{A \code{Lines} \code{object}.}

\item{\dots}{Additional arguments for the S3 method \code{'print'}.}
}
\value{
The \code{call} of the \code{object} of class \code{"Lines"}
and the \code{coefficients} of the line (in the form: \code{y = slope * x + intercept}).
}
\description{
Prints the \code{call} of the \code{object} of class \code{"Lines"}
and also the \code{coefficients} of the line (in the form: \code{y = slope * x + intercept}).
}
\examples{
A<-c(-1.22,-2.33); B<-c(2.55,3.75)
xr<-range(A,B);
xf<-(xr[2]-xr[1])*.1 #how far to go at the lower and upper ends in the x-coordinate
x<-seq(xr[1]-xf,xr[2]+xf,l=3) #try also l=10, 20 or 100

lnAB<-Line(A,B,x)
lnAB
print(lnAB)

}
\seealso{
\code{\link{summary.Lines}}, \code{\link{print.summary.Lines}}, and \code{\link{plot.Lines}}
}
