% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C_pm.R
\name{C_pm}
\alias{C_pm}
\title{\eqn{C_{pm}}}
\usage{
C_pm(mu, sigma, target, lsl, usl, dl)
}
\arguments{
\item{mu}{\code{numeric}.}

\item{sigma}{\code{numeric}.}

\item{target}{\code{numeric}. \eqn{T}.}

\item{lsl}{\code{numeric}.}

\item{usl}{\code{numeric}.}

\item{dl}{\code{numeric}. \eqn{L}, conventionally set to 6. Must be greater than
0.}
}
\value{
\code{double}.
}
\description{
\deqn{C_{pm} = \frac{\text{USL} - \text{LSL}}{L \sqrt{\sigma^2 +  (\mu - T)^2}}}

Only vectors of length 1 are recycled.

\code{NA}'s take precedence over \code{NaN}'s, e.g. \code{NaN + NA} will output \code{NA}.

Yields \code{NaN} if \code{sigma == 0} and \code{mu == target}.
}
\examples{
set.seed(1L)
data = rnorm(n = 30L, mean = 3., sd = 1.)
C_pm(mu = mean(data), sigma = sd(data), target = 3., lsl = 0., usl = 6., dl = 6.)
# [1] 1.077827

}
\references{
Montgomery, D. C. (2019). \emph{Introduction to statistical quality  control} (8th ed.). Wiley. ISBN: 978-1-119-39930-8
}
