% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcoxtimeplots.R
\name{plot.pcoxtimecv}
\alias{plot.pcoxtimecv}
\title{Plot solution path for pcoxtimecv}
\usage{
\method{plot}{pcoxtimecv}(
  x,
  ...,
  type = c("cve", "fit"),
  xvar = c("lambda", "l1"),
  show_nzero = FALSE,
  seed = 1234,
  geom = c("point", "line"),
  g.size = 0.2,
  g.col = "red",
  bar.col = g.col,
  scales = "free_x",
  show_min_cve = TRUE
)
}
\arguments{
\item{x}{fitted \code{\link[pcoxtime]{pcoxtimecv}} object.}

\item{...}{for future implementations}

\item{type}{which plot to return. \code{type = "cve"} (default) return a cross-validation curve and \code{type = "fit"} returns coefficient profiles (solution path). See details.}

\item{xvar}{only if \code{type = "fit"}. Plot coefficients a function of either lambda (\code{xvar = "lambda"}) or l1-norm (\code{xvar = "l1"}).}

\item{show_nzero}{logical. Whether to show number of nonzero coefficients on the plot. Default is \code{show_nzero = FALSE}. Still experimental for \code{type = "cve"}.}

\item{seed}{random number generator. Important if \code{refit = FALSE} in \code{\link[pcoxtime]{pcoxtimecv}}.}

\item{geom}{geom ("point" or "line") for partial likelihood}

\item{g.size}{size specification for points/lines}

\item{g.col}{colour specification for points/lines}

\item{bar.col}{colour specification for error bars}

\item{scales}{should scales be "fixed", "free", "free_x" or "free_y"?}

\item{show_min_cve}{whether or not to show the alpha which gives minimum cross-validation error. Ignored if a single \code{alpha} is specified. This replaced "Optimal" in the version \code{1.01.1} and below.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plots the cross-validation curve, and upper and lower standard deviation curves, as a function of the optimal lambdas. Also, plots the solution path as a function of optimal lambdas (or randomly picked fold, if \code{refit = FALSE}) or \code{l1}-norm.
}
\details{
To plot solution path corresponding to optimal alpha and lambda, set \code{refit = TRUE} in \code{\link[pcoxtime]{pcoxtimecv}}. The plot is a \code{\link[ggplot2]{ggplot}} object, hence can be be customized further.
}
\examples{

library(ggplot2)
# Time-varying covariates
\dontrun{
data(heart, package="survival")
# Using a vector of alphas = (0.8, 1)
cv1 <- pcoxtimecv(Surv(start, stop, event) ~ age + year + surgery + transplant
	, data = heart
	, alphas = c(0.8, 1)
	, refit = TRUE
	, lamfract = 0.6
	, seed = 1234
)
# Plot cross-validation curves
plot(cv1, type = "cve")

# Plot 
plot(cv1, type = "fit")
}
}
