% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simDegradation.r
\name{simDegradation}
\alias{simDegradation}
\title{DNA Degradation Simulator}
\usage{
simDegradation(data, kit, deg, quant.target, debug = FALSE)
}
\arguments{
\item{data}{data.frame with simulated data. Preferably output from  \code{\link{simSample}}.
Required columns are 'Allele', 'DNA', and 'Sim'.}

\item{kit}{character string for STR DNA amplification kit.}

\item{deg}{numeric for the estimated degradation probability (chance per base pair)}

\item{quant.target}{integer defining the quantification target size in base pair.}

\item{debug}{logical TRUE to indicate debug mode.}
}
\value{
data.frame with simulated results in columns 'Deg.Par', 'Deg.Prob', and 'Deg.DNA'.
}
\description{
Simulates the degradation of DNA.
}
\details{
Simulates the DNA degradation process by calculating the
probability that a DNA fragment of the specific size (bp) is complete
i.e. not degraded. Then a binomial selection of non-degraded molecules
takes place with the previously calculated probability.
The number of molecules is taken from the required column 'DNA' which is
\code{floor}ed to avoid NAs in the \code{rbinom} function.
}
\examples{
# Simulate profile.
# Get allele frequency database.
require(strvalidator)
db <- strvalidator::getDb(getDb()[2])
# Simulate profile.
res <- simProfile(kit= "ESX17", db=db, sim=10, name="Test")
# Simulate sample.
res <- simSample(data=res, cells=5000)
# Simulate degradation.
res <- simDegradation(data=res, kit="ESX17", deg=0.03, quant.target=80)
print(res)
}
\seealso{
\code{\link{simSample}}
}

