% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_analyse.R
\name{geo_sim}
\alias{geo_sim}
\title{Lm for sample similarity and geographical distance}
\usage{
geo_sim(otutab, geo, method = "bray", spe_nwk = NULL, ...)
}
\arguments{
\item{otutab}{an otutab data.frame, samples are columns, taxs are rows.}

\item{geo}{a two-columns dataframe, first is latitude, second is longitude}

\item{method}{Dissimilarity index, partial match to "bray", "euclidean"...see \code{\link[vegan]{vegdist};\link[picante]{unifrac}}}

\item{spe_nwk}{a phylo tree if use unifrac...}

\item{...}{additional}
}
\value{
a ggplot
}
\description{
Lm for sample similarity and geographical distance
}
\examples{
if (requireNamespace("NST") && requireNamespace("geosphere")) {
  library(ggplot2)
  data(otutab, package = "pcutils")
  metadata[, c("lat", "long")] -> geo
  geo_sim(otutab, geo) -> geo_res
  pcutils::my_lm(geo_res[4], "dis.geo", geo_res)
}
}
\references{
Graco-Roza, C. et al. (2022) Distance decay 2.0 - A global synthesis of taxonomic and functional turnover in ecological communities. Glob Ecol Biogeogr 31, 1399–1421.
}
