% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{group_box}
\alias{group_box}
\title{Plot a boxplot}
\usage{
group_box(
  tab,
  group = NULL,
  metadata = NULL,
  mode = 1,
  group_order = NULL,
  facet_order = NULL,
  alpha = FALSE,
  method = "wilcox",
  alpha_param = list(color = "red"),
  point_param = NULL,
  p_value1 = FALSE,
  p_value2 = FALSE,
  only_sig = TRUE,
  stat_compare_means_param = NULL,
  trend_line = FALSE,
  trend_line_param = list(color = "blue")
)
}
\arguments{
\item{tab}{your dataframe}

\item{group}{which colname choose for group or a vector}

\item{metadata}{the dataframe contains the group}

\item{mode}{1~9, plot style, try yourself}

\item{group_order}{the order of x group}

\item{facet_order}{the order of the facet}

\item{alpha}{whether plot a group alphabeta by test of method}

\item{method}{test method:wilcox, tukeyHSD, LSD, (default: wilcox), see \code{\link{multitest}}}

\item{alpha_param}{parameters parse to \code{\link[ggplot2]{geom_text}}}

\item{point_param}{parameters parse to \code{\link[ggplot2]{geom_jitter}}}

\item{p_value1}{multi-test of all group}

\item{p_value2}{two-test of each pair}

\item{only_sig}{only_sig for p_value2}

\item{stat_compare_means_param}{parameters parse to \code{\link[ggpubr]{stat_compare_means}}}

\item{trend_line}{add a trend line}

\item{trend_line_param}{parameters parse to \code{\link[ggplot2]{geom_smooth}}}
}
\value{
a ggplot
}
\description{
Plot a boxplot
}
\examples{
a <- data.frame(a = 1:18, b = runif(18, 0, 5))
group_box(a, group = rep(c("a", "b", "c"), each = 6))
}
