% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmViolin.R
\name{brmViolin}
\alias{brmViolin}
\title{Function to visualize hypotheses tested on brms models similar to those made using growthSS outputs.}
\usage{
brmViolin(fit, ss, hypothesis)
}
\arguments{
\item{fit}{A brmsfit object or a dataframe of draws. If you need to combine multiple models then
use \link{combineDraws} to merge their draws into a single dataframe for testing.}

\item{ss}{A \code{pcvrss} object. The only component that is currently used is the pcvrForm.}

\item{hypothesis}{A hypothesis expressed as a character string in the style of that used by
\code{brms::hypothesis} and \link{testGrowth}. Note that currently this only supports hypotheses
using two parameters from the model at a time (ie, "groupA / groupB > 1.05" works but
"(groupA / groupB) - (groupC / groupD) > 1" does not). In the hypothesis "..." can be used to mean
"all groups for this parameter" so that the hypothesis "... / A_group1 > 1.05" would include all
the "A" coefficients for groups 1:N along the x axis, see examples.}
}
\value{
Returns a ggplot showing a brms model's posterior distributions
as violins and filled by posterior probability of some hypothesis.
}
\description{
Function to visualize hypotheses tested on brms models similar to those made using growthSS outputs.
}
\examples{
\donttest{
set.seed(123)
simdf <- growthSim(
  "logistic",
  n = 20, t = 25,
  params = list("A" = c(200, 180, 190, 160), "B" = c(13, 11, 10, 10), "C" = c(3, 3, 3.25, 3.5))
)
ss <- growthSS(
  model = "logistic", form = y ~ time | id / group, sigma = "int",
  list("A" = 130, "B" = 10, "C" = 3),
  df = simdf, type = "brms"
)

fit <- fitGrowth(ss, backend = "cmdstanr", iter = 500, chains = 1, cores = 1)
brmViolin(fit, ss, ".../A_groupd > 1.05") # all groups used
brmViolin(fit, ss, "A_groupa/A_groupd > 1.05") # only these two groups
}

}
\keyword{Bayesian}
\keyword{brms}
\keyword{pcvrss}
