% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{pdf_render_page}
\alias{pdf_render_page}
\alias{poppler_config}
\alias{render}
\title{Render PDF to bitmap}
\usage{
pdf_render_page(pdf, page = 1, dpi = 72, numeric = TRUE, opw = "",
  upw = "")

poppler_config()
}
\arguments{
\item{pdf}{file path or raw vector with pdf data}

\item{page}{which page to render}

\item{dpi}{resolution (dots per inch) to render}

\item{numeric}{convert raw output to (0-1) real values}

\item{opw}{owner password}

\item{upw}{user password}
}
\description{
Renders a PDF page to a bitmap array which can be written to e.g.
png, jpeg or webp using the respective R packages. This function is only
available if libpoppler was compiled with cairo support.
}
\examples{
# Rendering not supported on Windows
if(poppler_config()$can_render){

file.copy(file.path(Sys.getenv("R_DOC_DIR"), "NEWS.pdf"), "news.pdf")
bitmap <- pdf_render_page("news.pdf")

# save to bitmap formats
png::writePNG(bitmap, "page.png")
jpeg::writeJPEG(bitmap, "page.jpeg")
webp::write_webp(bitmap, "page.webp")

# Higher quality
bitmap <- pdf_render_page("news.pdf", page = 1, dpi = 300)
png::writePNG(bitmap, "page.png")

# slightly more efficient
bitmap_raw <- pdf_render_page("news.pdf", numeric = FALSE)
webp::write_webp(bitmap_raw, "page.webp")
}
}
\seealso{
Other pdftools: \code{\link{pdf_info}}
}

