% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form-other.R
\name{form_mix}
\alias{form_mix}
\title{Form mixture of distributions}
\usage{
form_mix(f_list, weights = NULL)
}
\arguments{
\item{f_list}{List of pdqr-functions. Can have different
\link[=meta_class]{classes} and \link[=meta_type]{types} (see Details).}

\item{weights}{Numeric vector of weights or \code{NULL} (default; corresponds to
equal weights). Should be non-negative numbers with positive sum.}
}
\value{
A pdqr-function for mixture distribution of certain
\link[=meta_type]{type} and \link[=meta_class]{class} (see Details).
}
\description{
Based on a list of pdqr-functions and vector of weights form a pdqr-function
for corresponding mixture distribution.
}
\details{
\strong{Type of output mixture} is determined by the following algorithm:
\itemize{
\item If \code{f_list} consists only from pdqr-functions of "discrete" type, then
output will have "discrete" type.
\item If \code{f_list} has at least one pdqr-function of type "continuous", then
output will have "continuous" type. In this case all "discrete"
pdqr-functions in \code{f_list} are approximated with corresponding dirac-like
"continuous" functions (with \link[=form_retype]{form_retype(*, method = "dirac")}). \strong{Note} that this approximation has consequences
during computation of comparisons. For example, if original "discrete"
function \code{f} is for distribution with one element \code{x}, then probability of
\code{f >= x} being true is 1. After retyping to dirac-like function, this
probability will be 0.5, because of symmetrical dirac-like approximation.
Using a little nudge to \code{x} of \code{1e-7} magnitude in the correct direction
(\code{f >= x - 1e-7} in this case) will have expected output.
}

\strong{Class of output mixture} is determined by the class of the first element
of \code{f_list}. To change output class, use one of \verb{as_*()} functions to change
class of first element in \code{f_list} or class of output.

\strong{Note} that if output "continuous" pdqr-function for mixture distribution
(in theory) should have discontinuous density, it is approximated
continuously: discontinuities are represented as intervals in
\link[=meta_x_tbl]{"x_tbl"} with extreme slopes (see Examples).
}
\examples{
# All "discrete"
d_binom <- as_d(dbinom, size = 10, prob = 0.5)
r_pois <- as_r(rpois, lambda = 1)
dis_mix <- form_mix(list(d_binom, r_pois))
plot(dis_mix)

# All "continuous"
p_norm <- as_p(pnorm)
d_unif <- as_d(dunif)

con_mix <- form_mix(list(p_norm, d_unif), weights = c(0.7, 0.3))
  # Output is a p-function, as is first element of `f_list`
con_mix
plot(con_mix)

  # Use `as_*()` functions to change class
d_con_mix <- as_d(con_mix)

  # Theoretical output density should be discontinuous, but here it is
  # approximated with continuous function
con_x_tbl <- meta_x_tbl(con_mix)
con_x_tbl[(con_x_tbl$x >= -1e-4) & (con_x_tbl$x <= 1e-4), ]

# Some "discrete", some "continuous"
all_mix <- form_mix(list(d_binom, d_unif))
plot(all_mix)
all_x_tbl <- meta_x_tbl(all_mix)

  # What dirac-like approximation looks like
all_x_tbl[(all_x_tbl$x >= 1.5) & (all_x_tbl$x <= 2.5), ]

}
\seealso{
Other form functions: 
\code{\link{form_estimate}()},
\code{\link{form_regrid}()},
\code{\link{form_resupport}()},
\code{\link{form_retype}()},
\code{\link{form_smooth}()},
\code{\link{form_tails}()},
\code{\link{form_trans}()}
}
\concept{form functions}
