% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{methods-plot}
\alias{methods-plot}
\alias{plot.p}
\alias{plot.d}
\alias{plot.q}
\alias{plot.r}
\alias{lines.p}
\alias{lines.d}
\alias{lines.q}
\title{Pdqr methods for base plotting functions}
\usage{
\method{plot}{p}(x, y = NULL, n_extra_grid = 1001, ...)

\method{plot}{d}(x, y = NULL, n_extra_grid = 1001, ...)

\method{plot}{q}(x, y = NULL, n_extra_grid = 1001, ...)

\method{plot}{r}(x, y = NULL, n_sample = 1000, ...)

\method{lines}{p}(x, n_extra_grid = 1001, ...)

\method{lines}{d}(x, n_extra_grid = 1001, ...)

\method{lines}{q}(x, n_extra_grid = 1001, ...)
}
\arguments{
\item{x}{Pdqr-function to plot.}

\item{y}{Argument for compatibility with \code{plot()} signature. Doesn't used.}

\item{n_extra_grid}{Number of extra grid points at which to evaluate
pdqr-function (see Details). Supply \code{NULL} or \code{0} to not use extra grid.}

\item{...}{Other arguments for \code{plot()} or \link[graphics:hist]{hist()} (in
case of plotting r-function).}

\item{n_sample}{Size of a sample to be generated for plotting histogram in
case of an r-function.}
}
\value{
Output of \link[base:invisible]{invisible()} without arguments, i.e.
\code{NULL} without printing.
}
\description{
Pdqr-functions have their own methods for \code{\link[=plot]{plot()}} and \code{\link[=lines]{lines()}} (except
r-functions, see Details).
}
\details{
Main idea of plotting pdqr-functions is to use plotting mechanisms
for appropriate numerical data.

Plotting of \link[=meta_type]{type} \strong{discrete} functions:
\itemize{
\item P-functions are plotted as step-line with jumps at points of "x" column of
\link[=meta_x_tbl]{"x_tbl" metadata}.
\item D-functions are plotted with vertical lines at points of "x" column of
"x_tbl" with height equal to values from "prob" column.
\item Q-functions are plotted as step-line with jumps at points of "cumprob"
column of "x_tbl".
\item R-functions are plotted by generating sample of size \code{n_sample} and calling
\link[graphics:hist]{hist()} function.
}

Plotting of type \strong{continuous} functions:
\itemize{
\item P-functions are plotted in piecewise-linear fashion at their values on
compound grid: sorted union of "x" column from "x_tbl" metadata and sequence
of length \code{n_extra_grid} consisting from equidistant points between edges of
support. Here extra grid is needed to show curvature of lines between "x"
points from "x_tbl" (see Examples).
\item D-functions are plotted in the same way as p-functions.
\item Q-functions are plotted similarly as p- and d-functions but grid consists
from union of "cumprob" column of "x_tbl" metadata and equidistant grid of
length \code{n_extra_grid} from 0 to 1.
\item R-functions are plotted the same way as type "discrete" ones: as histogram
of generated sample of size \code{n_sample}.
}
}
\examples{
d_norm_1 <- as_d(dnorm)
d_norm_2 <- as_d(dnorm, mean = 1)

plot(d_norm_1)
lines(d_norm_2, col = "red")

# Usage of `n_extra_grid` is important in case of "continuous" p- and
# q-functions
simple_p <- new_p(data.frame(x = c(0, 1), y = c(0, 1)), "continuous")
plot(simple_p, main = "Case study of n_extra_grid argument")
lines(simple_p, n_extra_grid = 0, col = "red")

# R-functions are plotted with histogram
plot(as_r(d_norm_1))
}
\seealso{
Other pdqr methods for generic functions: 
\code{\link{methods-group-generic}},
\code{\link{methods-print}}
}
\concept{pdqr methods for generic functions}
