% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_p.R, R/new_d.R, R/new_q.R, R/new_r.R,
%   R/utils-new.R
\name{new_p}
\alias{new_p}
\alias{new_d}
\alias{new_q}
\alias{new_r}
\alias{new-pdqr}
\title{Create new pdqr-function}
\usage{
new_p(x, type, ...)

new_d(x, type, ...)

new_q(x, type, ...)

new_r(x, type, ...)
}
\arguments{
\item{x}{Numeric vector or data frame with appropriate columns (see "Data
frame input" section).}

\item{type}{\link[=meta_type]{Type} of pdqr-function. Should be one of "discrete"
or "continuous".}

\item{...}{Extra arguments for \link[stats:density]{density()}.}
}
\value{
A pdqr-function of corresponding \link[=meta_class]{class} ("p" for
\code{new_p()}, etc.) and \link[=meta_type]{type}.
}
\description{
Functions for creating new pdqr-functions based on numeric sample or data
frame describing distribution. They construct appropriate \link[=meta_x_tbl]{"x_tbl" metadata} based on the input and then create pdqr-function (of
corresponding \link[=meta_class]{pdqr class}) defined by that "x_tbl".
}
\details{
Data frame input \code{x} is treated as having enough information for
creating (including normalization of "y" column) an "x_tbl" metadata. For
more details see "Data frame input" section.

Numeric input is transformed into data frame which is then used as "x_tbl"
metadata (for more details see "Numeric input" section):
\itemize{
\item If \code{type} is \code{"discrete"} then \code{x} is viewed as sample from distribution
that can produce only values from \code{x}. Input is tabulated and normalized to
form "x_tbl" metadata.
\item If \code{type} is \code{"continuous"} then:
\itemize{
\item If \code{x} has 1 element, output distribution represents a \strong{dirac-like}
distribution which is an approximation to singular dirac distribution.
\item If \code{x} has more than 1 element, output distribution represents a
\strong{density estimation} with \link[stats:density]{density()} treating \code{x} as
sample.
}
}
}
\section{Numeric input}{


If \code{x} is a numeric vector, it is transformed into a data frame which is then
used as \link[=meta_x_tbl]{"x_tbl" metadata} to create pdqr-function of
corresponding class.

First, all \code{NaN}, \code{NA}, and infinite values are removed with warnings. If
there are no elements left, error is thrown. Then data frame is created in
the way which depends on the \code{type} argument.

\strong{For "discrete" type} elements of filtered \code{x} are:
\itemize{
\item Rounded to 10th digit to avoid numerical representation issues (see Note
in \code{\link{==}}'s help page).
\item Tabulated (all unique values are counted). Output data frame has three
columns: "x" with unique values, "prob" with normalized (divided by sum)
counts, "cumprob" with cumulative sum of "prob" column.
}

\strong{For "continuous" type} output data frame has columns "x", "y", "cumprob".
Choice of algorithm depends on the number of \code{x} elements:
\itemize{
\item If \code{x} has 1 element, an "x_tbl" metadata describes \strong{dirac-like}
"continuous" pdqr-function. It is implemented as triangular peak with center
at \code{x}'s value and width of \code{2e-8} (see Examples). This is an approximation
of singular dirac distribution. Data frame has columns "x" with value
\code{c(x-1e-8, x, x+1e-8)}, "y" with value \code{c(0, 1e8, 0)} normalized to have
total integral of "x"-"y" points of 1, "cumprob" \code{c(0, 0.5, 1)}.
\item If \code{x} has more than 1 element, it serves as input to
\link[stats:density]{density(x, ...)} for density estimation (here arguments in
\code{...} of \verb{new_*()} serve as extra arguments to \code{density()}). The output's "x"
element is used as "x" column in output data frame. Column "y" is taken as
"y" element of \code{density()} output, normalized so that piecewise-linear
function passing through "x"-"y" points has total integral of 1. Column
"cumprob" has cumulative probability of piecewise-linear d-function.
}
}

\section{Data frame input}{


If \code{x} is a data frame, it should have numeric columns appropriate for
\link[=meta_x_tbl]{"x_tbl" metadata} of input \code{type}: "x", "prob" for "discrete"
\code{type} and "x", "y" for "continuous" type ("cumprob" column will be computed
inside \verb{new_*()}). To become an appropriate "x_tbl" metadata, input data
frame is ordered in increasing order of "x" column and then \strong{imputed} in
the way which depends on the \code{type} argument.

\strong{For "discrete" type}:
\itemize{
\item Values in column "x" are rounded to 10th digit to avoid numerical
representation issues (see Note in \code{\link{==}}'s help page).
\item If there are duplicate values in "x" column, they are "squashed" into one
having sum of their probability in "prob" column.
\item Column "prob" is normalized by its sum to have total sum of 1.
\item Column "cumprob" is computed as cumulative sum of "prob" column.
}

\strong{For "continuous" type} column "y" is normalized so that piecewise-linear
function passing through "x"-"y" points has total integral of 1. Column
"cumprob" has cumulative probability of piecewise-linear d-function.
}

\examples{
set.seed(101)
x <- rnorm(10)

# Type "discrete": `x` values are directly tabulated
my_d_dis <- new_d(x, "discrete")
meta_x_tbl(my_d_dis)
plot(my_d_dis)

# Type "continuous": `x` serves as input to `density()`
my_d_con <- new_d(x, "continuous")
head(meta_x_tbl(my_d_con))
plot(my_d_con)

# Data frame input
## Values in "prob" column will be normalized automatically
my_p_dis <- new_p(data.frame(x = 1:4, prob = 1:4), "discrete")
## As are values in "y" column
my_p_con <- new_p(data.frame(x = 1:3, y = c(0, 10, 0)), "continuous")

# Using bigger bandwidth in `density()`
my_d_con_2 <- new_d(x, "continuous", adjust = 2)
plot(my_d_con, main = "Comparison of density bandwidths")
lines(my_d_con_2, col = "red")

# Dirac-like "continuous" pdqr-function is created if `x` is a single number
meta_x_tbl(new_d(1, "continuous"))
}
