% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdynmc_specTestFcst.R
\name{mtest.fct}
\alias{mtest.fct}
\title{Arellano and Bond Serial Correlation Test.}
\usage{
mtest.fct(object, t.order)
}
\arguments{
\item{object}{An object of class `pdynmc`.}

\item{t.order}{A number denoting the order of serial correlation to test for.}
}
\value{
An object of class `htest` which contains the Arellano and Bond m test
   statistic and corresponding p-value for the null hypothesis that there is no
   serial correlation of the given order.
}
\description{
\code{mtest.fct} tests for serial correlation in the error terms.
}
\details{
The null hypothesis is that there is no serial correlation of a
   particular order. The test statistic is computed as proposed by
   \insertCite{AreBon1991;textual}{pdynmc}.
}
\examples{
## Load data from plm package
if(!requireNamespace("plm", quietly = TRUE)){
 stop("Dataset from package \"plm\" needed for this example.
 Please install the package.", call. = FALSE)
} else{
 data(EmplUK, package = "plm")
 dat <- EmplUK
 dat[,c(4:7)] <- log(dat[,c(4:7)])
 dat <- dat[c(140:0), ]

## Code example
 m1 <- pdynmc(dat = dat, varname.i = "firm", varname.t = "year",
    use.mc.diff = TRUE, use.mc.lev = FALSE, use.mc.nonlin = FALSE,
    include.y = TRUE, varname.y = "emp", lagTerms.y = 2,
    fur.con = TRUE, fur.con.diff = TRUE, fur.con.lev = FALSE,
    varname.reg.fur = c("wage", "capital", "output"), lagTerms.reg.fur = c(1,2,2),
    include.dum = TRUE, dum.diff = TRUE, dum.lev = FALSE, varname.dum = "year",
    w.mat = "iid.err", std.err = "corrected", estimation = "onestep",
    opt.meth = "none")
 mtest.fct(m1, t.order = 2)
}

\donttest{
## Load data from plm package
if(!requireNamespace("plm", quietly = TRUE)){
 stop("Dataset from package \"plm\" needed for this example.
 Please install the package.", call. = FALSE)
} else{
 data(EmplUK, package = "plm")
 dat <- EmplUK
 dat[,c(4:7)] <- log(dat[,c(4:7)])

## Further code example
 m1 <- pdynmc(dat = dat, varname.i = "firm", varname.t = "year",
    use.mc.diff = TRUE, use.mc.lev = FALSE, use.mc.nonlin = FALSE,
    include.y = TRUE, varname.y = "emp", lagTerms.y = 2,
    fur.con = TRUE, fur.con.diff = TRUE, fur.con.lev = FALSE,
    varname.reg.fur = c("wage", "capital", "output"), lagTerms.reg.fur = c(1,2,2),
    include.dum = TRUE, dum.diff = TRUE, dum.lev = FALSE, varname.dum = "year",
    w.mat = "iid.err", std.err = "corrected", estimation = "onestep",
    opt.meth = "none")
 mtest.fct(m1, t.order = 2)
}
}


}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{pdynmc}} for fitting a linear dynamic panel data model.
}
