% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdynmc_exploratory.R
\name{strucUPD.plot}
\alias{strucUPD.plot}
\title{Plot on Structure of Unbalanced Panel Dataset.}
\usage{
strucUPD.plot(
  object,
  i.name = NULL,
  t.name = NULL,
  col.range = c("gold", "darkblue"),
  plot.name = "Unbalanced panel structure",
  ...
)
}
\arguments{
\item{object}{An object of class `data.frame`.}

\item{i.name}{Column name of cross-section identifier.}

\item{t.name}{Column name of time-series identifier.}

\item{col.range}{A vector of at least two colors used to
visualize the structure of the unbalanced panel data
set (defaults to 'gold' and 'darkblue'); must be a
valid argument to \link{col2rgb}.}

\item{plot.name}{A vector indicating the title of the plot
(defaults to 'Unbalanced panel structure').}

\item{...}{further arguments.}
}
\value{
Returns a plot for an unbalanced panel dataset
   contained in an object of class `data.frame` that
   visualizes the structure of the data. Cross-section
   dimension is plotted on the ordinate, longitudinal
   dimension on the abscissa. Each cross-sectional
   observation is represented by a bar. Breaks in the
   bars represent missing longitudinal observations.
}
\description{
\code{strucUPD.plot} Plot on cross-section and longtudinal
   structure of an object of class `data.frame` containing
   an unbalanced panel dataset.
}
\examples{
## Load data
data(ABdata, package = "pdynmc")
dat <- ABdata
dat[,c(4:7)] <- log(dat[,c(4:7)])

## Code example
strucUPD.plot(dat, i.name = "firm", t.name = "year")



}
\seealso{
\code{\link{pdynmc}} for fitting a linear dynamic panel data model.
}
\author{
Markus Fritsch, Joachim Schnurbus
}
