\name{ps_ouss}
\alias{ps_ouss}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Expected periodogram of the OUSS process
}
\description{
Returns the expected periodogram power of the Ornstein-Uhlenbeck state space (OUSS) process at a particular frequency, when sampled at regular time intervals for a finite time.
}
\usage{
ps_ouss(freq, power_o, sigma, 
        rho, lambda, 
        power_e, epsilon, 
        time_step, series_size)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{freq}{
    Single number or numeric vector. The frequency for which to the power spectrum is to be calculated.
}
  \item{power_o}{
    Single non-negative number. Power at zero-frequency generated by the underlying OU process, when sampled at the given \code{time_step}. Either \code{power_o} or \code{sigma} (but not both) must be provided.
}
  \item{sigma}{
    Single number. Standard deviation of OU fluctuations around equilibrium. Either \code{power_o} or \code{sigma} (but not both) must be provided.
  }
    \item{rho}{
    Single number between 0 (exclusive) and 1 (inclusive). Correlation of the OU process between two subsequent time points. Either \code{rho} or \code{lambda} (but not both) must be provided.
}
  \item{lambda}{
    Single non-negative number. Resilience (or relaxation rate) of the OU process. This is also the inverse correlation time of the OU process. Either \code{rho} or \code{lambda} (but not both) must be provided. 
}
  \item{power_e}{
    Single non-negative number. Asymptotic power at large frequencies due to the random measurement errors. Setting this to zero corresponds to the classical OU process. Either \code{power_e} or \code{epsilon} (but not both) must be provided.
}
  \item{epsilon}{
    Single number. Standard deviation of Gaussian measurement error. Setting this to zero corresponds to the classical OU process. Either \code{power_e} or \code{epsilon} (but not both) must be provided.
  }
  \item{time_step}{
    Positive number. The time step of the time series that was (or will be) used for periodogram generation.
}
  \item{series_size}{
    Positive integer. The number of sampled time points.
  }
}
\details{
The OUSS parameters \code{power_o}, \code{lambda} and \code{power_e} will typically be maximum-likelihood fitted values returned by \code{\link{evaluate.pm}}. The value of \code{time_step} is also returned by \code{\link{evaluate.pm}} and is inferred from the analysed time series. More generally, \code{power_o} and \code{power_e} are proportional to the OUSS parameters \code{sigma^2} and \code{epsilon^2} (see \code{\link{generate_ouss}}), respectively, but the exact scaling depends on the normalization used for the periodogram. 

In the limit where \code{series_size} becomes very large, \code{ps_ouss} becomes the same as \code{\link{ps_ouss_asymptotic}}.
}
\value{
Returns a numeric vector of the same size as \code{freq}, containing the corresponding expected periodogram powers of the OUSS process.
}
\references{
Louca, S., Doebeli, M. - Detecting cyclicity in ecological time series (in review, as of June 2014)
}
\author{
Stilianos Louca
}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{evaluate.pm}}, \code{\link{generate_ouss}}
}
\examples{
# generate OUSS time series
times  = seq(0,20,0.25);
signal = generate_ouss(times, mu=0, sigma=1, lambda=1, epsilon=0.5);

# calculate periodogram and fit OUSS model
report = evaluate.pm(times=times, signal=signal, startRadius=2);

# plot periodogram
plot(report$frequencies, report$periodogram, 
     type="l", ylab="power", xlab="frequency", main="periodogram & fitted OUSS power spectrum");

# plot expected OUSS periodogram
lines(report$frequencies, 
      ps_ouss(freq=report$frequencies, 
              power_o=report$power_o, 
              lambda=report$lambda, 
              power_e=report$power_e, 
              time_step=report$time_step,
              series_size=length(times)), 
      col="red");

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
