% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveSingleFileMultiEIC.R
\name{saveSingleFileMultiEIC}
\alias{saveSingleFileMultiEIC}
\title{Save to disk a plot of all ROI EIC and detected feature range}
\usage{
saveSingleFileMultiEIC(ROIsDataPoint, curveFit, foundPeakTable, savePath,
  width = 15, height = 15, verbose = TRUE)
}
\arguments{
\item{ROIsDataPoint}{(list) a list of \code{data.frame} of raw data points for each ROI (retention time "rt", mass "mz" and intensity "int" (as column) of each raw data points (as row)).}

\item{curveFit}{(list) a list of \code{peakPantheR_curveFit} or NA for each ROI}

\item{foundPeakTable}{(data.frame) \code{data.frame} as generated by \code{\link{findTargetFeatures}}, with features as rows and peak properties as columns. The following columns are mandatory: \code{cpdID}, \code{cpdName}, \code{rt}, \code{rtmin}, \code{rtmax}, \code{mzmin}, \code{mzmax}.}

\item{savePath}{(str) Full path to save a \emph{.png} of all ROI EICs , expect \code{'filepath/filename.png'}.}

\item{width}{(float) Width in cm for a single ROI plot (if more than one plot in total, 2 columns will be used). dpi set to a 100.}

\item{height}{(float) height in a cm for a single ROI plot. dpi set to 100}

\item{verbose}{(bool) if TRUE message progress}
}
\value{
None
}
\description{
Plot and save a \code{.png} of all ROI (x is RT, y is intensity), with the matching detected peak rt and peakwidth under it.
}
