% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakpicking.R
\name{detect.spikes}
\alias{detect.spikes}
\title{Detects spikes in series of numbers.}
\usage{
detect.spikes(mat, roi, winlen, spike.min.sd = 3, mc.cores = 1,
  verbose = FALSE)
}
\arguments{
\item{mat}{matrix of series with series organized columnwise.  The algorithm
treats each column separately.}

\item{roi}{vector of two integers (c(min, max)) defining positions in all
series (rows in mat) to consider for spike detection, used together with
winlen.  Must lie within the interval [2, nrow(mat) - 1].  Will be coerced
to integers.}

\item{winlen}{integer defining the window of positions to consider for mean
and sem estimation for each series.  Each estimation limits itself to the
position and a plus/minus winlen positions large window.  Thus, winlen must
not be chosen larger than that the windows fit within mat, given the roi.
I.e. roi[1] - winlen >=1 AND roi[length(roi)] + winlen <= nrow(mat).  Will
be coerced to an integer.}

\item{spike.min.sd}{numeric minimum number of standard deviations for a spike
to rise above the mean in order to be considered for a spike call and to be
excluded from the mean estimation of each subsequent iteration of the spike
calling algorithm}

\item{mc.cores}{the number of cores do perform this calculation}

\item{verbose}{Boolean indicating the number of new peaks detected with each
iteration.  The algorithm stops as soon as this number does not sink
anymore.  Turn this on if running into problems.}
}
\value{
boolean matrix corresponding to mat, representing spike positions.
}
\description{
This algorithm detects spikes rising above a user-specified number of
standard deviations numbers in a certain window.  Use this algorithm to
detect short spikes rather than smooth bumps in series of numbers.  Please
refer to the paper by Weber et al. for more details.
}
\references{
Weber, C.M., Ramachandran, S., and Henikoff, S. (2014).
  Nucleosomes are context-specific, H2A.Z-modulated barriers to RNA
  polymerase. Molecular Cell 53, 819-830.
}

