% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakpicking.R
\name{peakpick}
\alias{peakpick}
\title{Identifies smooth peaks in series of numbers.}
\usage{
peakpick(mat, neighlim, deriv.lim = 0.04, peak.min.sd = 0.5,
  peak.npos = 10L, mc.cores = 1)
}
\arguments{
\item{mat}{matrix of series with series organized columnwise}

\item{neighlim}{integer limit for how far apart peaks must be.  Peak pairs
closer than or equal to neighlim to each other have the lesser peak
eliminated.}

\item{deriv.lim}{numeric upper limit for the estimatied derivative for a
point to be considered for a peak call}

\item{peak.min.sd}{numeric minimum number of standard deviations for a peak
to rise above the mean of its immediate vicinity in order to be considered
for a peak call}

\item{peak.npos}{integer peak standard deviations and means will be estimated
plus/minus npos positions from peak}

\item{mc.cores}{the number of cores to perform this computation}
}
\value{
boolean matrix with dimensions of mat representing peaks
}
\description{
This algorithm detects peaks, smooth bumps in series of numbers.  This
algorithm should not be used for series containing brief spikes.  Consider
filtering/smoothing your data before using this algorithm.  Please refer to
the paper by Weber et al. for more details.
}
\references{
Weber, C.M., Ramachandran, S., and Henikoff, S. (2014).
  Nucleosomes are context-specific, H2A.Z-modulated barriers to RNA
  polymerase. Molecular Cell 53, 819-830.
}

