% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateGen.R
\name{simulateGen}
\alias{simulateGen}
\title{Simulate genotypes}
\usage{
simulateGen(ped, AF, mut.rate = 0)
}
\arguments{
\item{ped}{: Pedigree \code{data.frame} with columns for animal, sire, and dam identification.}

\item{AF}{: Vector of allele frequencies at different loci for the genotypes to be simulated.}

\item{mut.rate}{: Vector of mutation rates at different loci for the genotypes to be simulated, default = 0 for no mutation.}
}
\value{
M : The simulated genotype \code{data.frame} with rows corresponding to animals(in the same order as in the pedigree) and columns corresponding to markers.
}
\description{
Simulate genotypes for a given pedigree, allele frequency and mutation rate at each marker locus.
}
\details{
Only diploid and bi-allelic situations are covered.
No linkage disequilibrium is simulated.
}
\examples{
nSNP = 100
AF = runif(nSNP, 0.01, 0.99)
mut.rate = runif(nSNP, 0, 10^-5)
ped = data.frame(ID=1:5, SIRE=c(0,0,1,0,3), DAM=c(0,0,2,2,4))
gen = simulateGen(ped, AF, mut.rate)

}
