% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp_cdf_plot.R
\name{bp_cdf}
\alias{bp_cdf}
\title{Plot the CDF for Blood Pressure}
\usage{
bp_cdf(
  age,
  male,
  height = NA,
  height_percentile = 0.5,
  sbp = NA,
  dbp = NA,
  ...
)
}
\arguments{
\item{age}{numeric age, in months}

\item{male}{integer value, 1 = male, 0 = female, indicating sex of the
patient}

\item{height}{numeric, in centimeters, can be missing.  This is the length
for patients under three years of age}

\item{height_percentile}{default height percentile to use if \code{height} is
missing.}

\item{sbp, dbp}{observed values to plot on the CDF}

\item{...}{not currently used}
}
\value{
a \code{ggplot2} graphic showing the CDF for diastolic and systolic
blood pressures with vertical and horizontal lines highlight the percentile
for the given inputs.
}
\description{
Plot the CDF for blood pressure given age, sex, and height.
}
\examples{
bp_cdf(age = 96, male = 1, sbp = 103, dbp = 55)

}
