% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_for_age.R
\name{weight_for_age}
\alias{weight_for_age}
\alias{p_weight_for_age}
\alias{q_weight_for_age}
\alias{z_weight_for_age}
\title{Weight for Age - Pediatric Growth Standard}
\usage{
p_weight_for_age(
  q,
  male,
  age,
  source = getOption("pedbp_pgs_source", "CDC"),
  ...
)

q_weight_for_age(
  p,
  male,
  age,
  source = getOption("pedbp_pgs_source", "CDC"),
  ...
)

z_weight_for_age(
  q,
  male,
  age,
  source = getOption("pedbp_pgs_source", "CDC"),
  ...
)
}
\arguments{
\item{q}{a vector of quantiles}

\item{male}{integer value, 1 = male, 0 = female}

\item{age}{numeric age, in months}

\item{source}{a character string denoting the data source providing the
parameters needed for the estimate.  Valid values are "CDC" and "WHO".  This
can be set explicitly, or by using the \code{pedbp_pgs_source} option.}

\item{...}{pass through}

\item{p}{a vector of probabilities}
}
\value{
\code{p_} method return values from the estimated distribution function.

\code{q_} methods return values from the estimated quantile function.

\code{z_} methods return standard scores.
}
\description{
Weight for age quantile, distribution, and zscore function based on LMS data
from the CDC and WHO.
}
\section{Notes}{
 CDC Recommends using WHO growth charts for infants and
children ages 0 to 2 years of age in the U.S. and CDC growth charts to
monitor growth for children age 2 years and older in the U.S.
}

\examples{

# find the 80th quantile for 56 month old females;
# note - slight difference between CDC and WHO.
q_weight_for_age(p = 0.80, age = 56, male = 0, source = c("CDC", "WHO"))

# the percentiles for 42 kg 13 year old males:
p_weight_for_age(q = 42, age = 13 * 12, male = 0, source = "CDC")
p_weight_for_age(q = 42, age = 13 * 12, male = 0, source = "WHO")

z_weight_for_age(q = 42, age = 13 * 12, male = 0, source = "CDC")
z_weight_for_age(q = 42, age = 13 * 12, male = 0, source = "WHO")

}
\references{
\url{https://www.cdc.gov/growthcharts/percentile_data_files.htm},
\url{https://www.who.int/tools/child-growth-standards/standards}
}
\seealso{
\itemize{
\item Distribution functions:
  \itemize{
    \item \code{\link{bmi_for_age}}
    \item \code{\link{head_circumference_for_age}}
    \item \code{\link{height_for_age}}
    \item \code{\link{length_for_age}}
    \item \code{\link{weight_for_age}}
    \item \code{\link{weight_for_length}}
    \item \code{\link{weight_for_height}}
  }
\item Plotting functions:
  \itemize{
    \item \code{\link{gs_chart}}
    \item \code{\link{gs_cdf}}
  }
\item Vignette:
  \itemize{
    \item \code{vignette(topic = "growth-standards", package = "pedbp")}
  }
}
}
