% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md_stock_adj.R
\name{md_stock_adjust}
\alias{md_stock_adjust}
\title{adjust stock price for split and dividend}
\usage{
md_stock_adjust(dt, source, adjust = "split", adjfactor = NULL)
}
\arguments{
\item{dt}{a list/dataframe of time series datasets that didnt adjust for split or dividend.}

\item{source}{the available data sources are 'yahoo' (\url{http://finance.yahoo.com}) and '163' (\url{http://money.163.com}).}

\item{adjust}{adjust the OHLC prices for split (default), or dividend (both split and dividend). If it is NULL, return the original data.
For the yahoo data, the original data already adjust for split, and use the 'close_adj' column to adjust; for the 163 data, the original doesnot adjust any factors, and use the splits, dividends and issues to adjust.}

\item{adjfactor}{adjust factors, including splits and dividends. Defaults to NULL, which will load adjust factors from source. It can also download from md_stock when type set as adjfactor.}
}
\description{
\code{md_stock_adjust} adjusts the open, high, low and close stock prices for split and dividend.
}
\examples{
\donttest{
dt = md_stock('600547', source = '163', date_range = 'max', 
              type = 'history', adjust = NULL)
ds = md_stock('600547', source = '163', date_range = 'max', 
              type = 'adjfactor')

dtadj = md_stock_adjust(dt, source = '163', adjust = 'dividend', 
                        adjfactor = ds)
}
}
