% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_database.R
\name{freqDatabase}
\alias{freqDatabase}
\alias{getFrequencyDatabase}
\alias{setFrequencyDatabase}
\title{Allele frequency database}
\usage{
getFrequencyDatabase(x, markers = NULL)

setFrequencyDatabase(x, database, ...)
}
\arguments{
\item{x}{A \code{ped} object, or a list of such}

\item{markers}{A character vector (with marker names) or a numeric vector
(with marker indices)}

\item{database}{Either a data.frame or a character file path. See details.}

\item{...}{Optional arguments passed on to \code{\link[=read.table]{read.table()}}}
}
\value{
\itemize{
\item \code{getFrequencyDatabase} : a data.frame with allele labels as row names, and
marker labels as column names
\item \code{getFrequencyDatabase}: a modified version of \code{x}
}
}
\description{
Extract or set marker allele frequencies using the 'allelic ladder' format
}
\details{
These functions are essentially special cases of \code{\link[=getLocusAttributes]{getLocusAttributes()}} and
\code{\link[=setLocusAttributes]{setLocusAttributes()}}.

If \code{database} is a data.frame, it must have the allele labels as row names
and marker names as column names.

If \code{database} is a file path, it is read with the command
\code{read.table(database, header = T, row.names = 1, as.is = T, check.names = F, ...)}
}
\examples{
loc1 = list(name = "m1", alleles = 3:4, afreq = c(.1, .9))
loc2 = list(name = "m2", alleles = c("1", "10.2", "3"))
x = setMarkers(singleton(1), locus = list(loc1, loc2))
db = getFrequencyDatabase(x)
db

y = setFrequencyDatabase(x, database = db)
stopifnot(identical(x, y))

# The database can also be read directly from file
tmp = tempfile()
write.table(db, tmp, row.names = TRUE, col.names = TRUE)

z = setFrequencyDatabase(x, database = tmp)
stopifnot(all.equal(x, z))

}
\seealso{
\code{\link[=setLocusAttributes]{setLocusAttributes()}}, \code{\link[=setMarkers]{setMarkers()}}, \code{\link[=setAlleles]{setAlleles()}}
}
