% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker.R
\name{marker}
\alias{marker}
\alias{addMarker}
\title{Marker objects}
\usage{
marker(
  x,
  ...,
  geno = NULL,
  allelematrix = NULL,
  alleles = NULL,
  afreq = NULL,
  chrom = NA,
  posMb = NA,
  name = NA,
  mutmod = NULL,
  rate = NULL,
  NAstrings = c(0, "", NA, "-"),
  validate = TRUE,
  validateMut = validate
)

addMarker(
  x,
  ...,
  geno = NULL,
  allelematrix = NULL,
  alleles = NULL,
  afreq = NULL,
  chrom = NA,
  posMb = NA,
  name = NA,
  mutmod = NULL,
  rate = NULL,
  locusAttr = NULL,
  NAstrings = c(0, "", NA, "-"),
  validate = TRUE
)
}
\arguments{
\item{x}{A \code{ped} object.}

\item{...}{One or more expressions of the form \code{id = genotype}, where \code{id} is
the ID label of a member of \code{x}, and \code{genotype} is a numeric or character
vector of length 1 or 2 (see Examples).}

\item{geno}{A character vector of length \code{pedsize(x)}, with genotypes written
in the format "a/b".}

\item{allelematrix}{A matrix with 2 columns and \code{pedsize(x)} rows. If this is
non-NULL, then \code{...} must be empty.}

\item{alleles}{A character containing allele names. If not given, and \code{afreq}
is named, \code{names(afreq)} is used. The default action is to take the sorted
vector of distinct alleles occurring in \code{allelematrix}, \code{geno} or \code{...}.}

\item{afreq}{A numeric of the same length as \code{alleles}, indicating the
population frequency of each allele. A warning is issued if the frequencies
don't sum to 1 after rounding to 3 decimals. If the vector is named, and
\code{alleles} is not NULL, an error is raised if \code{setequal(names(afreq), alleles)} is not TRUE. If \code{afreq} is not specified, all alleles are given
equal frequencies.}

\item{chrom}{A single integer: the chromosome number. Default: NA.}

\item{posMb}{A nonnegative real number: the physical position of the marker,
in megabases. Default: NA.}

\item{name}{A character string: the name of the marker. Default: NA.}

\item{mutmod, rate}{Mutation model parameters to be passed on to
\code{\link[pedmut:mutationModel]{pedmut::mutationModel()}}; see there for details. Note: \code{mutmod}
corresponds to the \code{model} parameter. Default: NULL (no mutation model).}

\item{NAstrings}{A character vector containing strings to be treated as
missing alleles. Default: \code{c("", "0", NA, "-")}.}

\item{validate}{A logical indicating if the validity of the marker object
should be checked. Default: TRUE.}

\item{validateMut}{A logical indicating if the mutation model (if present)
should be checked.}

\item{locusAttr}{A list with names \code{alleles}, \code{afreq}, \code{chrom}, \code{name},
\code{posMb}, \code{mutmod}, \code{rate} (or a subset of these). This can be used as an
alternative to entering the arguments as function parameters.}
}
\value{
An object of class \code{marker}. This is an integer matrix with 2 columns
and one row per individual, and the following attributes:
\itemize{
\item \code{alleles} (a character vector with allele labels)
\item \code{afreq} (allele frequencies; default \code{rep.int(1/length(alleles),   length(alleles))})
\item \code{chrom} (chromosome number; default = NA)
\item \code{posMb} (physical location in megabases; default = NA)
\item \code{name} (marker identifier; default = NA)
\item \code{mutmod} (a list of two (male and female) mutation matrices; default =
NULL)
}
}
\description{
Creating a marker object associated with a pedigree. The function \code{marker()}
returns a marker object, while \code{addMarker()} first creates the marker and
then attaches it to \code{x}.
}
\examples{
x = nuclearPed(father = "fa", mother = "mo", children = "child")

# An empty SNP with alleles "A" and "B"
marker(x, alleles = c("A", "B"))

# Creating and attaching to `x`
addMarker(x, alleles = c("A", "B"))

# Alleles/frequencies can be given jointly or separately
stopifnot(identical(
  marker(x, afreq = c(A = 0.01, B = 0.99)),
  marker(x, alleles = c("A", "B"), afreq = c(0.01, 0.99)),
  ))

# Genotypes can be assigned individually ...
marker(x, fa = "1/1", mo = "1/2")

# ... or using the `geno` vector (all members in order)
marker(x, geno = c("1/1", "1/2", NA))


# Attaching a marker to the pedigree
m = marker(x) # By default a SNP with alleles 1,2
x = setMarkers(x, m)

# A marker with a "proportional" mutation model,
# with different rates for males and females
mutrates = list(female = 0.1, male = 0.2)
marker(x, alleles = 1:2, mutmod = "prop", rate = mutrates)

}
\seealso{
Get/set marker attributes: \link{marker_getattr}, \link{marker_setattr}.

Retrieve various marker properties: \link{marker_prop}, \code{\link[=nMarkers]{nMarkers()}},

Add alleles to an existing marker: \code{\link[=addAllele]{addAllele()}}

Attach multiple markers: \link{marker_attach}
}
