% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additional-options.R
\name{en_options_aug_lars}
\alias{en_options_aug_lars}
\alias{en_options}
\alias{en_options_dal}
\title{Additional Options for the EN Algorithms}
\usage{
en_options_aug_lars(use_gram = c("auto", "yes", "no"), eps = 1e-12)

en_options_dal(
  maxit = 100,
  eps = 1e-08,
  eta_mult = 2,
  eta_start_numerator = 0.01,
  eta_start,
  preconditioner = c("approx", "none", "diagonal"),
  verbosity = 0
)
}
\arguments{
\item{use_gram}{should the Gram matrix be pre-computed.}

\item{eps}{numeric tolerance for convergence.}

\item{maxit}{maximum number of iterations allowed.}

\item{eta_mult}{multiplier to increase eta at each iteration.}

\item{eta_start_numerator}{if \code{eta_start} is missing, it is defined
by \code{eta_start = eta_start_numerator / lambda}.}

\item{eta_start}{the start value for eta.}

\item{preconditioner}{preconditioner for the numerical solver. If none,
a standard solver will be used, otherwise the faster preconditioned
conjugate gradient is used.}

\item{verbosity}{verbosity of the algorithm.}
}
\value{
a checked options list.
}
\description{
Specify additional options for the augmented LARS and the DAL algorithm
to solve the EN problem.
}
\seealso{
Other specifying additional options: 
\code{\link{initest_options}()},
\code{\link{mstep_options}()},
\code{\link{pense_options}()}
}
\concept{specifying additional options}
