% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-methods.R
\name{predict.elnetfit}
\alias{predict.elnetfit}
\title{Predict Method for the classical Elastic Net Estimator}
\usage{
\method{predict}{elnetfit}(object, newdata, lambda, exact = FALSE, correction = TRUE, ...)
}
\arguments{
\item{object}{an object of type \code{elnetfit} to use for prediction.}

\item{newdata}{an optional design matrix}

\item{lambda}{the value of the penalty parameter. Default is to use the
optimal lambda \code{lambda_opt}.}

\item{exact}{if the lambda is not part of the lambda grid, should the
estimates be obtained by linear interpolation between the nearest
lambda values (default) or computed exactly.}

\item{correction}{should a correction factor be applied to the EN estimate?}

\item{...}{currently ignored.}
}
\value{
a numeric vector of predicted values for the given lambda.
}
\description{
Predict Method for the classical Elastic Net Estimator
}
\examples{
# Generate data with highly correlated groups of variables
set.seed(12345)
n <- 100
p <- 20
x <- 1 + matrix(rnorm(n * p), ncol = p)
x[, 2] <- x[, 1] + rnorm(n, sd = 0.01)
x[, 3] <- x[, 1] + rnorm(n, sd = 0.01)
x[, 5] <- x[, 4] + rnorm(n, sd = 0.01)
x[, 6] <- x[, 4] + rnorm(n, sd = 0.01)

y <- drop(x \%*\% c(rep(c(2, 5), each = 3), numeric(p - 6)) + rnorm(n))

# Compute the classical EN and select the optimal lambda by CV
set.seed(1234)
est_en_cv <- elnet_cv(
    x, y,
    alpha = 0.5,
    correction = TRUE
)

# For cross-validated EN fits, the `coef`, `predict`, and `residuals` methods
# return/use the estimated coefficients at the "optimal" lambda
coef(est_en_cv) # Extract coefficients
predict(est_en_cv) # Extract fitted values
predict(est_en_cv, newdata = x) # Predict values
residuals(est_en_cv) # Extract residuals

# We can also request the coefficient at another lambda. By default,
# this will interpolate between the solutions at the two surrounding
# lambda values.
coef(est_en_cv, lambda = 6)

# If needed, the solution at the given lambda can also be computed exactly.
coef(est_en_cv, lambda = 6, exact = TRUE)


# If we compute the EN estimator without choosing an optimal lambda,
# the lambda parameter needs to be specified in the call to coef
est_en <- elnet(
    x, y,
    alpha = 0.5
)

# Without specifying lambda, the `coef` method would raise an error.
coef(est_en, lambda = 6)
}
