% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_dend_utility_functions.R
\name{makeNewickRec}
\alias{makeNewickRec}
\title{Build the character string of nodes and haplotypes in Newick format}
\usage{
makeNewickRec(node, sep)
}
\arguments{
\item{node}{Tree(dend) node}

\item{sep}{A separator for haplotype names in the same clade. See the arguments in
\code{\link{reconstructPP}}.}
}
\description{
Build the character string of nodes and haplotypes in Newick format
}
\examples{

\dontshow{

data(ex_hapMatSmall_data)

# First, select a window of SNVs about a focal SNV.
SNV_win <- selectWindow(hapMat = ex_hapMatSmall_data,
                        focalSNV = 10, minWindow = 1)
                        
# Then order SNVs in the window.
ordHapmat <- orderSNVs(snvWin = SNV_win)

# Recursively partition haplotype matrix.
partitions <- makePartition(hapmat = ordHapmat, splitSNV = 1)

dendStrng <- makeNewickRec(node = partitions, sep = "-")

}

}
\keyword{internal}
