% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.lm.R
\name{model_performance.lm}
\alias{model_performance.lm}
\alias{model_performance.glm}
\title{Performance of (Generalized) Linear Models}
\usage{
\method{model_performance}{lm}(model, metrics = "all", ...)

\method{model_performance}{glm}(model, metrics = "all", ...)
}
\arguments{
\item{model}{Object of class \code{lm} or \code{glm}.}

\item{metrics}{Can be \code{"all"} or a character vector of metrics to be computed (some of \code{c("AIC", "BIC", "R2", "RMSE")}).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame (with one row) and one column per "index" (see \code{metrics}).
}
\description{
Compute indices of model performance for (generalized) linear models.
}
\examples{
model <- lm(mpg ~ wt + cyl, data = mtcars)
model_performance(model)

model <- glm(vs ~ wt + mpg, data = mtcars, family = "binomial")
model_performance(model)

}
