% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_score.R
\name{performance_score}
\alias{performance_score}
\title{Proper Scoring Rules}
\usage{
performance_score(model, verbose = TRUE)
}
\arguments{
\item{model}{Model with binary or count outcome.}

\item{verbose}{Toggle off warnings.}

\item{...}{Currently not used.}
}
\value{
A list with three elements, the logarithmic, quadratic/Brier and spherical score.
}
\description{
Calculates the logarithmic, quadratic/Brier and spherical score
  from a model with binary or count outcome.
}
\details{
Proper scoring rules can be used to evaluate the quality of model
predictions and model fit. \code{performance_score()} calculates the logarithmic,
quadratic/Brier and spherical scoring rules. The spherical rule takes values
in the interval \code{[0, 1]}, with values closer to 1 indicating a more
accurate model, and the logarithmic rule in the interval \code{[-Inf, 0]},
with values closer to 0 indicating a more accurate model.
}
\note{
Code is partially based on \href{https://drizopoulos.github.io/GLMMadaptive/reference/scoring_rules.html}{GLMMadaptive::scoring_rules()}.
}
\examples{
## Dobson (1990) Page 93: Randomized Controlled Trial :
counts <- c(18, 17, 15, 20, 10, 20, 25, 13, 12)
outcome <- gl(3, 1, 9)
treatment <- gl(3, 3)
model <- glm(counts ~ outcome + treatment, family = poisson())

performance_score(model)

\dontrun{
library(glmmTMB)
data(Salamanders)
model <- glmmTMB(
  count ~ spp + mined + (1 | site),
  zi =  ~ spp + mined,
  family = nbinom2(),
  data = Salamanders
)

performance_score(model)
}

}
\references{
Carvalho, A. (2016). An overview of applications of proper scoring rules. Decision Analysis 13, 223–242. \doi{10.1287/deca.2016.0337}
}
\seealso{
\code{\link[=performance_logloss]{performance_logloss()}}
}
