% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_performance.R
\name{compare_performance}
\alias{compare_performance}
\title{Compare performance of different models}
\usage{
compare_performance(
  ...,
  metrics = "all",
  rank = FALSE,
  bayesfactor = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{...}{Multiple model objects (also of different classes).}

\item{metrics}{Can be \code{"all"}, \code{"common"} or a character vector of metrics to be computed. See related \code{\link[=model_performance]{documentation}} of object's class for details.}

\item{rank}{Logical, if \code{TRUE}, models are ranked according to 'best' overall model performance. See 'Details'.}

\item{bayesfactor}{Logical, if \code{TRUE}, a Bayes factor for model comparisons is possibly returned. See 'Details'.}

\item{verbose}{Toggle off warnings.}
}
\value{
A data frame (with one row per model) and one column per "index" (see \code{metrics}).
}
\description{
\code{compare_performance()} computes indices of model performance for
different models at once and hence allows comparison of indices across models.
}
\details{
\subsection{Bayes factor for Model Comparison}{
  If all models were fit from the same data, \code{compare_performance()}
  returns an additional column named \code{BF}, which shows the Bayes factor
  (see \code{bayestestR::bayesfactor_models()}) for each model against
  the denominator model. The \emph{first} model is used as denominator model,
  and its Bayes factor is set to \code{NA} to indicate the reference model.
  }
  \subsection{Likelihood-Ratio Test}{
  If possible, \code{compare_performance()} conducts a likelihood-ratio test
  (see \code{\link{performance_lrt}}) and adds a column with the p-values
  from that test to the output. Thus, when a \code{"p"}-column is included,
  this refers to the likelihood-ratio test.
  }
  \subsection{Ranking Models}{
  When \code{rank = TRUE}, a new column \code{Performance_Score} is returned. This
  score ranges from 0\% to 100\%, higher values indicating better model performance.
  Note that all score value do not necessarily sum up to 100\%. Rather,
  calculation is based on normalizing all indices (i.e. rescaling them to a
  range from 0 to 1), and taking the mean value of all indices for each model.
  This is a rather quick heuristic, but might be helpful as exploratory index.
  \cr \cr
  When comparing frequentist models, both BIC and Bayes factor can be available.
  In such cases, since Bayes factor and BIC hold the same information (i.e.
  \code{cor(-$BIC, BF, method = "spearman")} is 1), the Bayes factor is ignored
  for the performance-score during ranking.
  \cr \cr
  In particular when models are of different types (e.g. mixed models, classical
  linear models, logistic regression, ...), not all indices will be computed
  for each model. In case where an index can't be calculated for a specific
  model type, this model gets an \code{NA} value. All indices that have any
  \code{NA}s are excluded from calculating the performance score.
  \cr \cr
  There is a \code{plot()}-method for \code{compare_performance()},
  which creates a "spiderweb" plot, where the different indices are
  normalized and larger values indicate better model performance.
  Hence, points closer to the center indicate worse fit indices
  (see \href{https://easystats.github.io/see/articles/performance.html}{online-documentation}
  for more details).
  }
}
\note{
There is also a \href{https://easystats.github.io/see/articles/performance.html}{\code{plot()}-method} implemented in the \href{https://easystats.github.io/see/}{\pkg{see}-package}.
}
\examples{
if (require("lme4")) {
  m1 <- lm(mpg ~ wt + cyl, data = mtcars)
  m2 <- glm(vs ~ wt + mpg, data = mtcars, family = "binomial")
  m3 <- lmer(Petal.Length ~ Sepal.Length + (1 | Species), data = iris)
  compare_performance(m1, m2, m3)
}

data(iris)
lm1 <- lm(Sepal.Length ~ Species, data = iris)
lm2 <- lm(Sepal.Length ~ Species + Petal.Length, data = iris)
lm3 <- lm(Sepal.Length ~ Species * Petal.Length, data = iris)
compare_performance(lm1, lm2, lm3)
compare_performance(lm1, lm2, lm3, rank = TRUE)
}
