% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotChr}
\alias{plotChr}
\title{Plotting one or two linkage maps}
\usage{
plotChr(map1, map2 = NULL, cex = 1, labels = c("Map 1", "Map 2"), ...)
}
\arguments{
\item{map1}{Numeric vector with marker positions.}

\item{map2}{Optional second map for comparison.}

\item{cex}{Font size in the figure.}

\item{labels}{Labels for the two blocks}

\item{...}{arguments are forwarded to \code{plot}.}
}
\value{
None. Plotting only.
}
\description{
Visualization of one or two linkage maps.
Used as comparison between two different maps (e.g. different parameters or linkage mapping tools).
}
\examples{
data(simTetra)
simTetraGen <- bases2genotypes(simTetra, 4)
rfMat <- calcRec(simTetraGen, 4)
split <- splitChr(rfMat, nchr = 7)
split <- sortLeafs(rfMat, split)
map <- pullMap(rfMat, split = split) 
plotChr(map[[1]])  
}

