% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadFile.R
\name{downloadFileButton}
\alias{downloadFileButton}
\title{downloadFileButton module UI function}
\usage{
downloadFileButton(id, downloadtypes = c("csv"), hovertext = NULL)
}
\arguments{
\item{id}{character id for the object}

\item{downloadtypes}{vector of values for data download types}

\item{hovertext}{tooltip hover text}
}
\value{
html span with tooltip and either shiny downloadButton in case of single download or shiny actionButton otherwise
}
\description{
Creates a custom high-functionality button for file downloads with two
states - single download type or multiple-download types.  The button image
and pop-up menu (if needed) are set accordingly.  A tooltip can also be set
for the button.
}
\section{Button Features}{

\itemize{
\item Consistent styling of the button, including a hover tooltip
\item Single or multiple types of downloads
\item Ability to download different data for each type of download
}
}

\section{Example}{

\code{downloadFileUI("mybuttonID1", c("csv", "tsv"), "Click Here")}
\code{downloadFileUI("mybuttonID2", "csv", "Click to download")}
}

\section{Shiny Usage}{

Call this function at the place in ui.R where the button should be placed.

It is paired with a call to \code{downloadFile(id, ...)}
in server.R
}

\examples{
if (interactive()) {
   library(shiny)
   library(periscope2)
   shinyApp(ui = fluidPage(fluidRow(column(width = 6,
     # single download type
     downloadFileButton("object_id1",
                        downloadtypes = c("csv"),
                        hovertext     = "Button 1 Tooltip")),
      column(width = 6,
      # multiple download types
      downloadFileButton("object_id2",
                         downloadtypes = c("csv", "tsv"),
                         hovertext     = "Button 2 Tooltip")))),
     server = function(input, output) {
       # single download type
       downloadFile(id           = "object_id1",
                    logger       = "",
                    filenameroot = "mydownload1",
                    datafxns     = list(csv = reactiveVal(iris)),
                    aspectratio  = 1)
       # multiple download types
       downloadFile(id           = "object_id2",
                    logger       = "",
                    filenameroot = "mydownload2",
                    datafxns     = list(csv = reactiveVal(mtcars),
                    tsv = reactiveVal(mtcars)))
   })
}

}
\seealso{
\link[periscope2]{downloadFile}

\link[periscope2]{downloadFile_ValidateTypes}

\link[periscope2]{downloadFile_AvailableTypes}

\link[periscope2]{logViewerOutput}

\link[periscope2]{downloadablePlot}

\link[periscope2]{downloadableTableUI}

\link[periscope2]{downloadableTable}
}
