% Generated by roxygen2 (4.0.1): do not edit by hand
\name{shape}
\alias{shape}
\title{Calculate (phylogenetic) shape: examine assemblage composition}
\usage{
shape(data, metric = c("all-quick", "all", "psv", "psr", "mpd", "mntd", "pd",
  "colless", "gamma", "taxon", "eigen.sum", "eed", "hed", "dist.fd"),
  sqrt.phy = FALSE, traitgram = NULL, traitgram.p = 2, ext.dist = NULL,
  which.eigen = 1, remove.errors = TRUE, ...)
}
\arguments{
\item{data}{\code{\link{comparative.comm}} object}

\item{metric}{metrics to calculate. Default (\code{all-quick})
calculates everything bar \code{fd.dist}, \code{all} calculates
everything. Individually call-able metrics are: \code{psv},
\code{psr}, \code{mpd}, \code{mntd}, \code{pd}, \code{colless},
\code{gamma}, \code{taxon}, \code{eigen.sum}, \code{eed}, \code{hed}, &
\code{dist.fd}. Note that \code{dist.fd} is a trait distance
metric, but will be calculated on the phylogenetic distance matrix
if not traits are supplied, and the external/square-rooted
phylogenetic distance matrix if either is specified.}

\item{which.eigen}{The eigen vector to calculate for the PhyloEigen
metric (\code{eigen.sum})}

\item{sqrt.phy}{If TRUE (default is FALSE) your phylogenetic
distance matrix will be square-rooted; specifying TRUE will force
the square-root transformation on phylogenetic distance matrices
(in the spirit of Leitten and Cornwell, 2014). See `details' for
details about different metric calculations when a distance matrix
is used.}

\item{traitgram}{If not NULL (default), a number to be passed to
\code{funct.phylo.dist} (\code{phyloWeight}; the `a' parameter),
causing analysis on a distance matrix reflecting both traits and
phylogeny (0 --> only phylogeny, 1 --> only traits; see
\code{funct.phylo.dist}). If a vector of numbers is given,
\code{shape} iterates across them and returns a \code{data.frame}
with coefficients from each iteration. See `details' for details
about different metric calculations when a distance matrix is used.}

\item{traitgram.p}{A value for `p' to be used in conjunction with
\code{traitgram} when calling \code{funct.phylo.dist}.}

\item{remove.errors}{suppress errors about metrics that failed to
run (default: TRUE). This will happen for some metrics if you have,
for example, only one species in a community.}

\item{ext.dist}{Supply an external species-level distance matrix
for use in calculations. See `details' for comments on the use of
distance matrices in different metric calculations.}

\item{...}{Additional arguments to passed to metric functions
(unlikely you will want this!)}
}
\value{
\code{phy.structure} list object of metric values. Use
\code{coefs} to extract a summary metric table, or examine each
individual metric (which gives more details for each) by calling
\code{print} on the output (i.e., type \code{output} in the example
below).
}
\description{
Calculate (phylogenetic) shape: examine assemblage composition
}
\details{
Calculates various metrics of phylogenetic biodiversity
that are categorized as \emph{shape} metrics by Pearse \emph{et
al.} (2014).
}
\note{
As mentioned above, \code{dist.fd} is calculated using a
phylogenetic distance matrix if no trait data are available, or if
you specify \code{sqrt.phy}. It is not calculated by default
because it generates warning messsages (which WDP is loathe to
suppress) which are related to the general tendency for a low rank
of phylogenetic distance matrices. Much ink has been written about
this, and in par this problem is why the \code{eigen.sum} measure
came to be suggested.
}
\examples{
data(laja)
data <- comparative.comm(invert.tree, river.sites, invert.traits)
(output<-shape(data))
str(output)
shape(data, "colless")
shape(data, "eigen.sum", which.eigen=2)
}
\author{
M.R. Helmus, Will Pearse
}
\references{
Pearse W.D., Purvis A., Cavender-Bares J. & Helmus M.R. (2014). Metrics and Models of Community Phylogenetics. In: Modern Phylogenetic Comparative Methods and Their Application in Evolutionary Biology. Springer Berlin Heidelberg, pp. 451-464.

\code{PSV,PSR} Helmus M.R., Bland T.J., Williams C.K. & Ives A.R. (2007). Phylogenetic measures of biodiversity. American Naturalist, 169, E68-E83.

\code{PD} Faith D.P. (1992). Conservation evaluation and phylogenetic diversity. Biological Conservation, 61, 1-10.

\code{colless} Colless D.H. (1982). Review of phylogenetics: the theory and practice of phylogenetic systematics. Systematic Zoology, 31, 100-104.

\code{gamma} Pybus O.G. & Harvey P.H. (2000) Testing macro-evolutionary models using incomplete molecular phylogenies. _Proceedings of the Royal Society of London. Series B. Biological Sciences 267: 2267--2272.

\code{taxon} Clarke K.R. & Warwick R.M. (1998). A taxonomic distinctness index and its statistical properties. J. Appl. Ecol., 35, 523-531.

\code{eigen.sum} Diniz-Filho J.A.F., Cianciaruso M.V., Rangel T.F. & Bini L.M. (2011). Eigenvector estimation of phylogenetic and functional diversity. Functional Ecology, 25, 735-744.

\code{eed,hed} (i.e., \emph{Eed, Hed}) Cadotte M.W., Davies T.J., Regetz J., Kembel S.W., Cleland E. & Oakley T.H. (2010). Phylogenetic diversity metrics for ecological communities: integrating species richness, abundance and evolutionary history. Ecology Letters, 13, 96-105.
}
\seealso{
\code{\link{evenness}} \code{\link{dispersion}} \code{\link{dissimilarity}}
}

